/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.eventlistener.StageCpuDistribution;
import io.trino.spi.eventlistener.StageGcStatistics;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryStatistics {
    private final Duration cpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Optional<Duration> scheduledTime;
    private final Optional<Duration> waitingTime;
    private final Optional<Duration> analysisTime;
    private final Optional<Duration> planningTime;
    private final Optional<Duration> executionTime;
    private final long peakUserMemoryBytes;
    private final long peakTotalNonRevocableMemoryBytes;
    private final long peakTaskUserMemory;
    private final long peakTaskTotalMemory;
    private final long physicalInputBytes;
    private final long physicalInputRows;
    private final long internalNetworkBytes;
    private final long internalNetworkRows;
    private final long totalBytes;
    private final long totalRows;
    private final long outputBytes;
    private final long outputRows;
    private final long writtenBytes;
    private final long writtenRows;
    private final double cumulativeMemory;
    private final double cumulativeSystemMemory;
    private final List<StageGcStatistics> stageGcStatistics;
    private final int completedSplits;
    private final boolean complete;
    private final List<StageCpuDistribution> cpuTimeDistribution;
    private final List<String> operatorSummaries;
    private final Optional<String> planNodeStatsAndCosts;

    @JsonCreator
    public QueryStatistics(Duration cpuTime, Duration wallTime, Duration queuedTime, Optional<Duration> scheduledTime, Optional<Duration> waitingTime, Optional<Duration> analysisTime, Optional<Duration> planningTime, Optional<Duration> executionTime, long peakUserMemoryBytes, long peakTotalNonRevocableMemoryBytes, long peakTaskUserMemory, long peakTaskTotalMemory, long physicalInputBytes, long physicalInputRows, long internalNetworkBytes, long internalNetworkRows, long totalBytes, long totalRows, long outputBytes, long outputRows, long writtenBytes, long writtenRows, double cumulativeMemory, double cumulativeSystemMemory, List<StageGcStatistics> stageGcStatistics, int completedSplits, boolean complete, List<StageCpuDistribution> cpuTimeDistribution, List<String> operatorSummaries, Optional<String> planNodeStatsAndCosts) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.scheduledTime = Objects.requireNonNull(scheduledTime, "scheduledTime is null");
        this.waitingTime = Objects.requireNonNull(waitingTime, "waitingTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.planningTime = Objects.requireNonNull(planningTime, "planningTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.peakUserMemoryBytes = peakUserMemoryBytes;
        this.peakTotalNonRevocableMemoryBytes = peakTotalNonRevocableMemoryBytes;
        this.peakTaskUserMemory = peakTaskUserMemory;
        this.peakTaskTotalMemory = peakTaskTotalMemory;
        this.physicalInputBytes = physicalInputBytes;
        this.physicalInputRows = physicalInputRows;
        this.internalNetworkBytes = internalNetworkBytes;
        this.internalNetworkRows = internalNetworkRows;
        this.totalBytes = totalBytes;
        this.totalRows = totalRows;
        this.outputBytes = outputBytes;
        this.outputRows = outputRows;
        this.writtenBytes = writtenBytes;
        this.writtenRows = writtenRows;
        this.cumulativeMemory = cumulativeMemory;
        this.cumulativeSystemMemory = cumulativeSystemMemory;
        this.stageGcStatistics = Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null");
        this.completedSplits = completedSplits;
        this.complete = complete;
        this.cpuTimeDistribution = Objects.requireNonNull(cpuTimeDistribution, "cpuTimeDistribution is null");
        this.operatorSummaries = Objects.requireNonNull(operatorSummaries, "operatorSummaries is null");
        this.planNodeStatsAndCosts = Objects.requireNonNull(planNodeStatsAndCosts, "planNodeStatsAndCosts is null");
    }

    @JsonProperty
    public Duration getCpuTime() {
        return this.cpuTime;
    }

    @JsonProperty
    public Duration getWallTime() {
        return this.wallTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Optional<Duration> getScheduledTime() {
        return this.scheduledTime;
    }

    @JsonProperty
    public Optional<Duration> getResourceWaitingTime() {
        return this.waitingTime;
    }

    @JsonProperty
    public Optional<Duration> getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Optional<Duration> getPlanningTime() {
        return this.planningTime;
    }

    @JsonProperty
    public Optional<Duration> getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public long getPeakUserMemoryBytes() {
        return this.peakUserMemoryBytes;
    }

    @JsonProperty
    public long getPeakTotalNonRevocableMemoryBytes() {
        return this.peakTotalNonRevocableMemoryBytes;
    }

    @JsonProperty
    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory;
    }

    @JsonProperty
    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    @JsonProperty
    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public long getPhysicalInputRows() {
        return this.physicalInputRows;
    }

    @JsonProperty
    public long getInternalNetworkBytes() {
        return this.internalNetworkBytes;
    }

    @JsonProperty
    public long getInternalNetworkRows() {
        return this.internalNetworkRows;
    }

    @JsonProperty
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @JsonProperty
    public long getTotalRows() {
        return this.totalRows;
    }

    @JsonProperty
    public long getOutputBytes() {
        return this.outputBytes;
    }

    @JsonProperty
    public long getOutputRows() {
        return this.outputRows;
    }

    @JsonProperty
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @JsonProperty
    public long getWrittenRows() {
        return this.writtenRows;
    }

    @JsonProperty
    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    @JsonProperty
    public double getCumulativeSystemMemory() {
        return this.cumulativeSystemMemory;
    }

    @JsonProperty
    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public boolean isComplete() {
        return this.complete;
    }

    @JsonProperty
    public List<StageCpuDistribution> getCpuTimeDistribution() {
        return this.cpuTimeDistribution;
    }

    @JsonProperty
    public List<String> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public Optional<String> getPlanNodeStatsAndCosts() {
        return this.planNodeStatsAndCosts;
    }
}

