/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class KeyStoreHolder {
    private KeyStore keyStore = null;

    public KeyStoreHolder() throws KeyStoreException {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(null, null);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyStoreException("KeyStore creation error", e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setCertificate(String alias, Certificate certificate) throws KeyStoreException {
        try {
            this.keyStore.setCertificateEntry(alias, certificate);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException("Failed to set the certificate", e);
        }
    }

    public void setPrivateKey(String alias, PrivateKey privateKey, Certificate[] certChain) throws KeyStoreException {
        try {
            this.keyStore.setKeyEntry(alias, privateKey, "".toCharArray(), certChain);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException("Failed to set the private key", e);
        }
    }
}

