/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.security.PrincipalType;
import java.util.Locale;
import java.util.Objects;

public class TrinoPrincipal {
    private final PrincipalType type;
    private final String name;

    @JsonCreator
    public TrinoPrincipal(@JsonProperty(value="type") PrincipalType type, @JsonProperty(value="name") String name) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null").toLowerCase(Locale.ENGLISH);
    }

    @JsonProperty
    public PrincipalType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinoPrincipal trinoPrincipal = (TrinoPrincipal)o;
        return this.type == trinoPrincipal.type && Objects.equals(this.name, trinoPrincipal.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

