/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryMetadata;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;

public class QueryCreatedEvent {
    private final Instant createTime;
    private final QueryContext context;
    private final QueryMetadata metadata;

    @JsonCreator
    public QueryCreatedEvent(Instant createTime, QueryContext context, QueryMetadata metadata) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @JsonProperty
    public Instant getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public QueryContext getContext() {
        return this.context;
    }

    @JsonProperty
    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return new StringJoiner(", ", QueryCreatedEvent.class.getSimpleName() + "[", "]").add("queryId='" + this.getMetadata().getQueryId() + "'").toString();
    }
}

