/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});

    private JsonUtils() {
    }

    public static <T> T parseJson(Path path, Class<T> javaType) {
        if (!path.isAbsolute()) {
            path = path.toAbsolutePath();
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File does not exist: %s", (Object)path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"File is not readable: %s", (Object)path);
        try {
            byte[] json = Files.readAllBytes(path);
            return JsonUtils.parseJson(json, javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON file '%s' for '%s'", path, javaType), e);
        }
    }

    public static JsonNode parseJson(String json) {
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse JSON node from given byte array", e);
        }
    }

    public static <T> T jsonTreeToValue(JsonNode treeNode, Class<T> javaType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)treeNode, javaType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to parse JSON tree node", (IOException)((Object)e));
        }
    }

    @VisibleForTesting
    static <T> T parseJson(byte[] jsonBytes, Class<T> javaType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(jsonBytes, javaType);
    }
}

