/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.execution.warnings.WarningCollector;
import io.trino.operator.scalar.timestamp.TimestampToVarcharCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToVarcharCast;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Values;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class ShowStatsRewrite
implements StatementRewrite.Rewrite {
    private static final Expression NULL_DOUBLE = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)DoubleType.DOUBLE));
    private static final Expression NULL_VARCHAR = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR));
    private final QueryExplainerFactory queryExplainerFactory;
    private final StatsCalculator statsCalculator;

    @Inject
    public ShowStatsRewrite(QueryExplainerFactory queryExplainerFactory, StatsCalculator statsCalculator) {
        this.queryExplainerFactory = Objects.requireNonNull(queryExplainerFactory, "queryExplainerFactory is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, parameters, this.queryExplainerFactory.createQueryExplainer(analyzerFactory), warningCollector, this.statsCalculator).process((Node)node, null);
    }

    private static Expression toDoubleLiteral(double value) {
        if (!Double.isFinite(value)) {
            return NULL_DOUBLE;
        }
        return new DoubleLiteral(Double.toString(value));
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final List<Expression> parameters;
        private final QueryExplainer queryExplainer;
        private final WarningCollector warningCollector;
        private final StatsCalculator statsCalculator;

        private Visitor(Session session, List<Expression> parameters, QueryExplainer queryExplainer, WarningCollector warningCollector, StatsCalculator statsCalculator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        }

        protected Node visitShowStats(ShowStats node, Void context) {
            Query query = this.getRelation(node);
            Plan plan = this.queryExplainer.getLogicalPlan(this.session, (Statement)query, this.parameters, this.warningCollector);
            CachingStatsProvider cachingStatsProvider = new CachingStatsProvider(this.statsCalculator, this.session, plan.getTypes());
            PlanNodeStatsEstimate stats = cachingStatsProvider.getStats(plan.getRoot());
            return this.rewriteShowStats(plan, stats);
        }

        private Query getRelation(ShowStats node) {
            if (node.getRelation() instanceof Table) {
                return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)node.getRelation());
            }
            if (node.getRelation() instanceof TableSubquery) {
                return ((TableSubquery)node.getRelation()).getQuery();
            }
            throw new IllegalArgumentException("Expected either TableSubquery or Table as relation");
        }

        private Node rewriteShowStats(Plan plan, PlanNodeStatsEstimate planNodeStatsEstimate) {
            List<String> statsColumnNames = Visitor.buildColumnsNames();
            List<SelectItem> selectItems = Visitor.buildSelectItems(statsColumnNames);
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            Verify.verify((boolean)(plan.getRoot() instanceof OutputNode), (String)"Expected plan root be OutputNode, but was: %s", (Object)plan.getRoot().getClass().getName());
            OutputNode root = (OutputNode)plan.getRoot();
            for (int columnIndex = 0; columnIndex < root.getOutputSymbols().size(); ++columnIndex) {
                Symbol outputSymbol = root.getOutputSymbols().get(columnIndex);
                String columnName = root.getColumnNames().get(columnIndex);
                Type columnType = plan.getTypes().get(outputSymbol);
                SymbolStatsEstimate symbolStatistics = planNodeStatsEstimate.getSymbolStatistics(outputSymbol);
                ImmutableList.Builder rowValues = ImmutableList.builder();
                rowValues.add((Object)new StringLiteral(columnName));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getAverageRowSize() * planNodeStatsEstimate.getOutputRowCount() * (1.0 - symbolStatistics.getNullsFraction())));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getDistinctValuesCount()));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getNullsFraction()));
                rowValues.add((Object)NULL_DOUBLE);
                rowValues.add((Object)Visitor.toStringLiteral(columnType, symbolStatistics.getLowValue()));
                rowValues.add((Object)Visitor.toStringLiteral(columnType, symbolStatistics.getHighValue()));
                rowsBuilder.add((Object)new Row((List)rowValues.build()));
            }
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(planNodeStatsEstimate.getOutputRowCount()));
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            rowsBuilder.add((Object)new Row((List)rowValues.build()));
            ImmutableList resultRows = rowsBuilder.build();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll(selectItems), (Relation)QueryUtil.aliased((Relation)new Values((List)resultRows), (String)"table_stats", statsColumnNames));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        private static List<String> buildColumnsNames() {
            return ImmutableList.builder().add((Object)"column_name").add((Object)"data_size").add((Object)"distinct_values_count").add((Object)"nulls_fraction").add((Object)"row_count").add((Object)"low_value").add((Object)"high_value").build();
        }

        private static List<SelectItem> buildSelectItems(List<String> columnNames) {
            return (List)columnNames.stream().map(QueryUtil::unaliasedName).collect(ImmutableList.toImmutableList());
        }

        private static Expression toStringLiteral(Type type, double value) {
            if (!Double.isFinite(value)) {
                return NULL_VARCHAR;
            }
            if (type == BooleanType.BOOLEAN) {
                String representation = value == 0.0 ? "false" : (value == 1.0 ? "true" : Double.toString(value));
                return new StringLiteral(representation);
            }
            if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
                return new StringLiteral(Long.toString(Math.round(value)));
            }
            if (type.equals(DoubleType.DOUBLE) || type instanceof DecimalType) {
                return new StringLiteral(Double.toString(value));
            }
            if (type.equals(RealType.REAL)) {
                return new StringLiteral(Float.toString((float)value));
            }
            if (type.equals(DateType.DATE)) {
                return new StringLiteral(LocalDate.ofEpochDay(Math.round(value)).toString());
            }
            if (type instanceof TimestampType) {
                long epochMicros = (long)value;
                int outputPrecision = Math.min(((TimestampType)type).getPrecision(), 6);
                return new StringLiteral(TimestampToVarcharCast.cast((long)outputPrecision, epochMicros).toStringUtf8());
            }
            if (type instanceof TimestampWithTimeZoneType) {
                long millisUtc = (long)value;
                int outputPrecision = Math.min(((TimestampWithTimeZoneType)type).getPrecision(), 3);
                return new StringLiteral(TimestampWithTimeZoneToVarcharCast.cast((long)outputPrecision, DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY)).toStringUtf8());
            }
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }
}

