/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import java.util.List;
import java.util.Objects;

public final class StandardFunctionResolution {
    private final Session session;
    private final Metadata metadata;

    public StandardFunctionResolution(Session session, Metadata metadata) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public ResolvedFunction arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return this.metadata.resolveOperator(this.session, operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }

    public ResolvedFunction comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return this.metadata.resolveOperator(this.session, operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }
}

