/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.Patterns;

public class RemoveRedundantEnforceSingleRowNode
implements Rule<EnforceSingleRowNode> {
    private static final Pattern<EnforceSingleRowNode> PATTERN = Patterns.enforceSingleRow();

    @Override
    public Pattern<EnforceSingleRowNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(EnforceSingleRowNode node, Captures captures, Rule.Context context) {
        if (QueryCardinalityUtil.isScalar(node.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        return Rule.Result.empty();
    }
}

