/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.connector.CatalogName;
import io.trino.execution.Lifespan;
import io.trino.metadata.Split;
import io.trino.spi.connector.ConnectorPartitionHandle;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface SplitSource
extends Closeable {
    public CatalogName getCatalogName();

    public ListenableFuture<SplitBatch> getNextBatch(ConnectorPartitionHandle var1, Lifespan var2, int var3);

    @Override
    public void close();

    public boolean isFinished();

    public Optional<List<Object>> getTableExecuteSplitsInfo();

    public static class SplitBatch {
        private final List<Split> splits;
        private final boolean lastBatch;

        public SplitBatch(List<Split> splits, boolean lastBatch) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.lastBatch = lastBatch;
        }

        public List<Split> getSplits() {
            return this.splits;
        }

        public boolean isLastBatch() {
            return this.lastBatch;
        }
    }
}

