/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.security.SecureRandom;
import java.util.Objects;

public final class Slug {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final HashFunction hmac;

    public static Slug createNew() {
        byte[] randomBytes = new byte[16];
        RANDOM.nextBytes(randomBytes);
        return new Slug(randomBytes);
    }

    private Slug(byte[] slugKey) {
        this.hmac = Hashing.hmacSha1((byte[])Objects.requireNonNull(slugKey, "slugKey is null"));
    }

    public String makeSlug(Context context, long token) {
        return "y" + this.hmac.newHasher().putInt(Objects.requireNonNull(context, "context is null").ordinal()).putLong(token).hash().toString();
    }

    public boolean isValid(Context context, String slug, long token) {
        return this.makeSlug(context, token).equals(slug);
    }

    public static enum Context {
        QUEUED_QUERY,
        EXECUTING_QUERY;

    }
}

