/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Framing;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.WindowFrame;

public class RowsFraming
implements Framing {
    private final FrameInfo frameInfo;
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;

    public RowsFraming(FrameInfo frameInfo, int partitionStart, int partitionEnd, PagesIndex pagesIndex) {
        Preconditions.checkArgument((frameInfo.getType() == WindowFrame.Type.ROWS ? 1 : 0) != 0, (String)"Frame must be of type ROWS, actual: %s", (Object)frameInfo.getType());
        this.frameInfo = frameInfo;
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
    }

    @Override
    public Framing.Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int rowPosition = currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        if (this.emptyFrame(this.frameInfo, rowPosition, endPosition)) {
            return new Framing.Range(-1, -1);
        }
        int frameStart = this.frameInfo.getStartType() == FrameBound.Type.UNBOUNDED_PRECEDING ? 0 : (this.frameInfo.getStartType() == FrameBound.Type.PRECEDING ? RowsFraming.preceding(rowPosition, this.getValue(this.frameInfo.getStartChannel(), currentPosition)) : (this.frameInfo.getStartType() == FrameBound.Type.FOLLOWING ? RowsFraming.following(rowPosition, endPosition, this.getValue(this.frameInfo.getStartChannel(), currentPosition)) : rowPosition));
        int frameEnd = this.frameInfo.getEndType() == FrameBound.Type.UNBOUNDED_FOLLOWING ? endPosition : (this.frameInfo.getEndType() == FrameBound.Type.PRECEDING ? RowsFraming.preceding(rowPosition, this.getValue(this.frameInfo.getEndChannel(), currentPosition)) : (this.frameInfo.getEndType() == FrameBound.Type.FOLLOWING ? RowsFraming.following(rowPosition, endPosition, this.getValue(this.frameInfo.getEndChannel(), currentPosition)) : rowPosition));
        return new Framing.Range(frameStart, frameEnd);
    }

    private boolean emptyFrame(FrameInfo frameInfo, int rowPosition, int endPosition) {
        FrameBound.Type startType = frameInfo.getStartType();
        FrameBound.Type endType = frameInfo.getEndType();
        int positions = endPosition - rowPosition;
        if (startType == FrameBound.Type.UNBOUNDED_PRECEDING && endType == FrameBound.Type.PRECEDING) {
            return this.getValue(frameInfo.getEndChannel(), 0) > (long)rowPosition;
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
            return this.getValue(frameInfo.getStartChannel(), 0) > (long)positions;
        }
        if (startType != endType) {
            return false;
        }
        FrameBound.Type type = frameInfo.getStartType();
        if (type != FrameBound.Type.PRECEDING && type != FrameBound.Type.FOLLOWING) {
            return false;
        }
        long start = this.getValue(frameInfo.getStartChannel(), 0);
        long end = this.getValue(frameInfo.getEndChannel(), 0);
        if (type == FrameBound.Type.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        return start > end || start > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Math.toIntExact((long)rowPosition - value);
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Math.toIntExact((long)rowPosition + value);
    }

    private long getValue(int channel, int currentPosition) {
        Preconditions.checkState((!this.pagesIndex.isNull(channel, currentPosition) ? 1 : 0) != 0, (Object)"Window frame offset must not be null");
        long value = this.pagesIndex.getLong(channel, currentPosition);
        Preconditions.checkState((value >= 0L ? 1 : 0) != 0, (Object)"Window frame offset must not be negative");
        return value;
    }
}

