/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ValueWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import io.trino.spi.function.WindowFunctionSignatures;
import io.trino.util.Failures;
import java.util.List;

@WindowFunctionSignatures(value={@WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T"}), @WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T", "bigint"}), @WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T", "bigint", "T"})})
public class LeadFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int offsetChannel;
    private final int defaultChannel;
    private final boolean ignoreNulls;

    public LeadFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.size() > 1 ? argumentChannels.get(1) : -1;
        this.defaultChannel = argumentChannels.size() > 2 ? argumentChannels.get(2) : -1;
        this.ignoreNulls = ignoreNulls;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (this.offsetChannel >= 0 && this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long valuePosition;
            long offset = this.offsetChannel < 0 ? 1L : this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 0", new Object[0]);
            if (this.ignoreNulls && offset > 0L) {
                long count = 0L;
                valuePosition = currentPosition + 1;
                while (this.withinPartition(valuePosition) && (this.windowIndex.isNull(this.valueChannel, Math.toIntExact(valuePosition)) || ++count != offset)) {
                    ++valuePosition;
                }
            } else {
                valuePosition = (long)currentPosition + offset;
            }
            if (this.withinPartition(valuePosition)) {
                this.windowIndex.appendTo(this.valueChannel, Math.toIntExact(valuePosition), output);
            } else if (this.defaultChannel >= 0) {
                this.windowIndex.appendTo(this.defaultChannel, currentPosition, output);
            } else {
                output.appendNull();
            }
        }
    }

    private boolean withinPartition(long valuePosition) {
        return valuePosition >= 0L && valuePosition < (long)this.windowIndex.size();
    }
}

