/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.CovarianceState;

public interface RegressionState
extends CovarianceState {
    public double getM2X();

    public void setM2X(double var1);

    @Override
    default public void update(double x, double y) {
        double oldMeanX = this.getMeanX();
        CovarianceState.super.update(x, y);
        this.setM2X(this.getM2X() + (x - oldMeanX) * (x - this.getMeanX()));
    }

    default public double getRegressionSlope() {
        double dividend = this.getC2();
        double divisor = this.getM2X();
        return dividend / divisor;
    }

    default public void merge(RegressionState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        long na = this.getCount();
        long nb = otherState.getCount();
        this.setM2X(this.getM2X() + otherState.getM2X() + (double)(na * nb) * Math.pow(this.getMeanX() - otherState.getMeanX(), 2.0) / (double)(na + nb));
        CovarianceState.super.merge(otherState);
    }

    default public double getRegressionIntercept() {
        double slope = this.getRegressionSlope();
        double meanX = this.getMeanX();
        double meanY = this.getMeanY();
        return meanY - slope * meanX;
    }
}

