/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceResources
extends BaseResources<Policies> {
    private static final Logger log = LoggerFactory.getLogger(NamespaceResources.class);
    private final IsolationPolicyResources isolationPolicies;
    private final PartitionedTopicResources partitionedTopicResources;
    private final MetadataStore configurationStore;
    private final MetadataStore localStore;
    public static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";
    private static final String NAMESPACE_BASE_PATH = "/namespace";
    private static final String BUNDLE_DATA_BASE_PATH = "/loadbalance/bundle-data";

    public NamespaceResources(MetadataStore localStore, MetadataStore configurationStore, int operationTimeoutSec) {
        this(localStore, configurationStore, operationTimeoutSec, ForkJoinPool.commonPool());
    }

    public NamespaceResources(MetadataStore localStore, MetadataStore configurationStore, int operationTimeoutSec, Executor executor) {
        super(configurationStore, Policies.class, operationTimeoutSec);
        this.configurationStore = configurationStore;
        this.isolationPolicies = new IsolationPolicyResources(configurationStore, operationTimeoutSec);
        this.partitionedTopicResources = new PartitionedTopicResources(configurationStore, operationTimeoutSec, executor);
        this.localStore = localStore;
    }

    public CompletableFuture<List<String>> listNamespacesAsync(String tenant) {
        return this.getChildrenAsync(NamespaceResources.joinPath("/admin/policies", tenant));
    }

    public CompletableFuture<Boolean> getPoliciesReadOnlyAsync() {
        return super.existsAsync(POLICIES_READONLY_FLAG_PATH);
    }

    public boolean getPoliciesReadOnly() throws MetadataStoreException {
        try {
            return this.getPoliciesReadOnlyAsync().get(this.getOperationTimeoutSec(), TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to check exist /admin/flags/policies-readonly", (Throwable)e);
        }
    }

    public void createPolicies(NamespaceName ns, Policies policies) throws MetadataStoreException {
        this.create(NamespaceResources.joinPath("/admin/policies", ns.toString()), policies);
    }

    public CompletableFuture<Void> createPoliciesAsync(NamespaceName ns, Policies policies) {
        return this.createAsync(NamespaceResources.joinPath("/admin/policies", ns.toString()), policies);
    }

    public boolean namespaceExists(NamespaceName ns) throws MetadataStoreException {
        String path = NamespaceResources.joinPath("/admin/policies", ns.toString());
        return super.exists(path) && super.getChildren(path).isEmpty();
    }

    public CompletableFuture<Boolean> namespaceExistsAsync(NamespaceName ns) {
        String path = NamespaceResources.joinPath("/admin/policies", ns.toString());
        return this.getCache().exists(path).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.getChildrenAsync(path).thenApply(children -> children.isEmpty());
        });
    }

    public void deletePolicies(NamespaceName ns) throws MetadataStoreException {
        this.delete(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public CompletableFuture<Void> deletePoliciesAsync(NamespaceName ns) {
        return this.deleteIfExistsAsync(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public Optional<Policies> getPolicies(NamespaceName ns) throws MetadataStoreException {
        return this.get(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    @Deprecated
    public Optional<Policies> getPoliciesIfCached(NamespaceName ns) {
        return this.getCache().getIfCached(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public CompletableFuture<Optional<Policies>> getPoliciesAsync(NamespaceName ns) {
        return this.getCache().get(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public void setPolicies(NamespaceName ns, Function<Policies, Policies> function) throws MetadataStoreException {
        this.set(NamespaceResources.joinPath("/admin/policies", ns.toString()), function);
    }

    public CompletableFuture<Void> setPoliciesAsync(NamespaceName ns, Function<Policies, Policies> function) {
        return this.setAsync(NamespaceResources.joinPath("/admin/policies", ns.toString()), function);
    }

    public static boolean pathIsFromNamespace(String path) {
        return path.startsWith("/admin/policies/") && path.substring("/admin/policies".length() + 1).contains("/");
    }

    public static boolean pathIsNamespaceLocalPolicies(String path) {
        return path.startsWith("/admin/local-policies/") && path.substring("/admin/local-policies".length() + 1).contains("/");
    }

    public CompletableFuture<Void> deleteNamespaceAsync(NamespaceName ns) {
        String namespacePath = NamespaceResources.joinPath(NAMESPACE_BASE_PATH, ns.toString());
        return this.getStore().deleteRecursive(namespacePath);
    }

    public CompletableFuture<Void> deleteTenantAsync(String tenant) {
        String tenantPath = NamespaceResources.joinPath(NAMESPACE_BASE_PATH, tenant);
        return this.deleteIfExistsAsync(tenantPath);
    }

    public static NamespaceName namespaceFromPath(String path) {
        return NamespaceName.get((String)path.substring("/admin/policies".length() + 1));
    }

    public static NamespaceName namespaceFromLocalPoliciesPath(String path) {
        return NamespaceName.get((String)path.substring("/admin/local-policies".length() + 1));
    }

    public CompletableFuture<Void> deleteBundleDataAsync(NamespaceName ns) {
        String namespaceBundlePath = NamespaceResources.joinPath(BUNDLE_DATA_BASE_PATH, ns.toString());
        return this.localStore.deleteRecursive(namespaceBundlePath);
    }

    public CompletableFuture<Void> deleteBundleDataTenantAsync(String tenant) {
        String tenantBundlePath = NamespaceResources.joinPath(BUNDLE_DATA_BASE_PATH, tenant);
        return this.localStore.deleteRecursive(tenantBundlePath);
    }

    @Generated
    public IsolationPolicyResources getIsolationPolicies() {
        return this.isolationPolicies;
    }

    @Generated
    public PartitionedTopicResources getPartitionedTopicResources() {
        return this.partitionedTopicResources;
    }

    @Generated
    public MetadataStore getConfigurationStore() {
        return this.configurationStore;
    }

    @Generated
    public MetadataStore getLocalStore() {
        return this.localStore;
    }

    public static class IsolationPolicyResources
    extends BaseResources<Map<String, NamespaceIsolationDataImpl>> {
        private static final String NAMESPACE_ISOLATION_POLICIES = "namespaceIsolationPolicies";

        public IsolationPolicyResources(MetadataStore store, int operationTimeoutSec) {
            super(store, new TypeReference<Map<String, NamespaceIsolationDataImpl>>(){}, operationTimeoutSec);
        }

        public Optional<NamespaceIsolationPolicies> getIsolationDataPolicies(String cluster) throws MetadataStoreException {
            Optional data = super.get(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES));
            return data.isPresent() ? Optional.of(new NamespaceIsolationPolicies((Map)data.get())) : Optional.empty();
        }

        public CompletableFuture<Optional<NamespaceIsolationPolicies>> getIsolationDataPoliciesAsync(String cluster) {
            return this.getAsync(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES)).thenApply(data -> data.map(NamespaceIsolationPolicies::new));
        }

        public void deleteIsolationData(String cluster) throws MetadataStoreException {
            this.delete(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES));
        }

        public CompletableFuture<Void> deleteIsolationDataAsync(String cluster) {
            return this.deleteAsync(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES));
        }

        public void createIsolationData(String cluster, Map<String, NamespaceIsolationDataImpl> id) throws MetadataStoreException {
            this.create(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), id);
        }

        public void setIsolationData(String cluster, Function<Map<String, NamespaceIsolationDataImpl>, Map<String, NamespaceIsolationDataImpl>> modifyFunction) throws MetadataStoreException {
            this.set(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), modifyFunction);
        }

        public CompletableFuture<Void> setIsolationDataAsync(String cluster, Function<Map<String, NamespaceIsolationDataImpl>, Map<String, NamespaceIsolationDataImpl>> modifyFunction) {
            return this.setAsync(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), modifyFunction);
        }

        public CompletableFuture<Void> setIsolationDataWithCreateAsync(String cluster, Function<Optional<Map<String, NamespaceIsolationDataImpl>>, Map<String, NamespaceIsolationDataImpl>> createFunction) {
            return this.setWithCreateAsync(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), createFunction);
        }

        public void setIsolationDataWithCreate(String cluster, Function<Optional<Map<String, NamespaceIsolationDataImpl>>, Map<String, NamespaceIsolationDataImpl>> createFunction) throws MetadataStoreException {
            this.setWithCreate(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), createFunction);
        }
    }

    public static class PartitionedTopicResources
    extends BaseResources<PartitionedTopicMetadata> {
        private static final String PARTITIONED_TOPIC_PATH = "/admin/partitioned-topics";
        private final Executor executor;

        public PartitionedTopicResources(MetadataStore configurationStore, int operationTimeoutSec, Executor executor) {
            super(configurationStore, PartitionedTopicMetadata.class, operationTimeoutSec);
            this.executor = executor;
        }

        public CompletableFuture<Void> updatePartitionedTopicAsync(TopicName tn, Function<PartitionedTopicMetadata, PartitionedTopicMetadata> f) {
            return this.setAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), f);
        }

        public void createPartitionedTopic(TopicName tn, PartitionedTopicMetadata tm) throws MetadataStoreException {
            this.create(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), tm);
        }

        public CompletableFuture<Void> createPartitionedTopicAsync(TopicName tn, PartitionedTopicMetadata tm) {
            return this.createAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), tm);
        }

        public CompletableFuture<List<String>> listPartitionedTopicsAsync(NamespaceName ns, TopicDomain domain) {
            return this.getChildrenAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, ns.toString(), domain.value())).thenApply(list -> list.stream().map(x -> TopicName.get((String)domain.value(), (NamespaceName)ns, (String)Codec.decode((String)x)).toString()).collect(Collectors.toList()));
        }

        public CompletableFuture<Optional<PartitionedTopicMetadata>> getPartitionedTopicMetadataAsync(TopicName tn) {
            return this.getPartitionedTopicMetadataAsync(tn, false);
        }

        public CompletableFuture<Optional<PartitionedTopicMetadata>> getPartitionedTopicMetadataAsync(TopicName tn, boolean refresh) {
            if (refresh) {
                return this.refreshAndGetAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
            }
            return this.getAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public boolean partitionedTopicExists(TopicName tn) throws MetadataStoreException {
            return this.exists(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Boolean> partitionedTopicExistsAsync(TopicName tn) {
            return this.existsAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Void> deletePartitionedTopicAsync(TopicName tn) {
            return this.deleteAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Void> clearPartitionedTopicMetadataAsync(NamespaceName namespaceName) {
            String globalPartitionedPath = PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, namespaceName.toString());
            log.info("Clearing partitioned topic metadata for namespace {}, path is {}", (Object)namespaceName, (Object)globalPartitionedPath);
            return this.getStore().deleteRecursive(globalPartitionedPath);
        }

        public CompletableFuture<Void> clearPartitionedTopicTenantAsync(String tenant) {
            String partitionedTopicPath = PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tenant);
            log.info("Clearing partitioned topic metadata for tenant {}, path is {}", (Object)tenant, (Object)partitionedTopicPath);
            return this.deleteIfExistsAsync(partitionedTopicPath);
        }

        public CompletableFuture<Void> markPartitionedTopicDeletedAsync(TopicName tn) {
            if (tn.isPartitioned()) {
                return CompletableFuture.completedFuture(null);
            }
            if (log.isDebugEnabled()) {
                log.debug("markPartitionedTopicDeletedAsync {}", (Object)tn);
            }
            return this.updatePartitionedTopicAsync(tn, md -> {
                md.deleted = true;
                return md;
            });
        }

        public CompletableFuture<Void> unmarkPartitionedTopicDeletedAsync(TopicName tn) {
            if (tn.isPartitioned()) {
                return CompletableFuture.completedFuture(null);
            }
            if (log.isDebugEnabled()) {
                log.debug("unmarkPartitionedTopicDeletedAsync {}", (Object)tn);
            }
            return this.updatePartitionedTopicAsync(tn, md -> {
                md.deleted = false;
                return md;
            });
        }

        public CompletableFuture<Boolean> isPartitionedTopicBeingDeletedAsync(TopicName tn) {
            if (tn.isPartitioned()) {
                tn = TopicName.get((String)tn.getPartitionedTopicName());
            }
            return this.getPartitionedTopicMetadataAsync(tn, true).thenApply(mdOpt -> mdOpt.map(partitionedTopicMetadata -> partitionedTopicMetadata.deleted).orElse(false));
        }

        public CompletableFuture<Void> runWithMarkDeleteAsync(TopicName topic, Supplier<CompletableFuture<Void>> supplier) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.markPartitionedTopicDeletedAsync(topic).whenCompleteAsync((markResult, markExc) -> {
                boolean mdFound;
                if (markExc != null) {
                    if (!(markExc.getCause() instanceof MetadataStoreException.NotFoundException)) {
                        log.error("Failed to mark the topic {} as deleted", (Object)topic, markExc);
                        future.completeExceptionally((Throwable)markExc);
                        return;
                    }
                    mdFound = false;
                } else {
                    mdFound = true;
                }
                ((CompletableFuture)supplier.get()).whenComplete((deleteResult, deleteExc) -> {
                    if (deleteExc != null && mdFound) {
                        ((CompletableFuture)this.unmarkPartitionedTopicDeletedAsync(topic).thenRun(() -> future.completeExceptionally((Throwable)deleteExc))).exceptionally(ex -> {
                            log.warn("Failed to unmark the topic {} as deleted", (Object)topic, ex);
                            future.completeExceptionally((Throwable)deleteExc);
                            return null;
                        });
                    } else if (deleteExc != null) {
                        future.completeExceptionally((Throwable)deleteExc);
                    } else {
                        future.complete((Void)deleteResult);
                    }
                });
            }, this.executor);
            return future;
        }
    }
}

