/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ClassLoaderSafeRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeRecordSet(@ForClassLoaderSafe RecordSet delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public List<Type> getColumnTypes() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getColumnTypes();
            return list;
        }
    }

    public RecordCursor cursor() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor();
            return recordCursor;
        }
    }
}

