/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.json.JsonFieldDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonFieldDecoder;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonRowDecoderFactory;

public class PulsarJsonRowDecoder
implements PulsarRowDecoder {
    private final Map<DecoderColumnHandle, JsonFieldDecoder> fieldDecoders;
    private final GenericJsonSchema genericJsonSchema;
    private static final Logger log = Logger.get(PulsarJsonRowDecoderFactory.class);

    public PulsarJsonRowDecoder(GenericJsonSchema genericJsonSchema, Set<DecoderColumnHandle> columns) {
        this.genericJsonSchema = Objects.requireNonNull(genericJsonSchema, "genericJsonSchema is null");
        this.fieldDecoders = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), PulsarJsonFieldDecoder::new));
    }

    private static JsonNode locateNode(JsonNode tree, DecoderColumnHandle columnHandle) {
        String mapping = columnHandle.getMapping();
        Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for %s", (Object)columnHandle.getName());
        JsonNode currentNode = tree;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)mapping)) {
            if (!currentNode.has(pathElement)) {
                return MissingNode.getInstance();
            }
            currentNode = currentNode.path(pathElement);
        }
        return currentNode;
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(ByteBuf byteBuf) {
        GenericJsonRecord record = (GenericJsonRecord)this.genericJsonSchema.decode(byteBuf);
        JsonNode tree = record.getJsonNode();
        HashMap<DecoderColumnHandle, FieldValueProvider> decodedRow = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        for (Map.Entry<DecoderColumnHandle, JsonFieldDecoder> entry : this.fieldDecoders.entrySet()) {
            DecoderColumnHandle columnHandle = entry.getKey();
            JsonFieldDecoder decoder = entry.getValue();
            JsonNode node = PulsarJsonRowDecoder.locateNode(tree, columnHandle);
            decodedRow.put(columnHandle, decoder.decode(node));
        }
        return Optional.of(decodedRow);
    }
}

