/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.ClearSpaceQuotaOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="clrquota", description={"clear quota of the bucket. At least one of the quota clear flag is mandatory."})
public class ClearQuotaHandler
extends BucketHandler {
    @CommandLine.Mixin
    private ClearSpaceQuotaOptions clrSpaceQuota;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneBucket bucket = client.getObjectStore().getVolume(volumeName).getBucket(bucketName);
        boolean isOptionPresent = false;
        if (this.clrSpaceQuota.getClrSpaceQuota()) {
            bucket.clearSpaceQuota();
            isOptionPresent = true;
        }
        if (this.clrSpaceQuota.getClrNamespaceQuota()) {
            bucket.clearNamespaceQuota();
            isOptionPresent = true;
        }
        if (!isOptionPresent) {
            throw new IOException("At least one of the quota clear flag is required.");
        }
    }
}

