/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import picocli.CommandLine;

public class ListLimitOptions {
    @CommandLine.ArgGroup
    private ExclusiveGroup group = new ExclusiveGroup();

    public boolean isAll() {
        return this.group.all;
    }

    public int getLimit() {
        if (this.group.all) {
            return Integer.MAX_VALUE;
        }
        if (this.group.limit < 1) {
            throw new IllegalArgumentException("List length should be a positive number");
        }
        return this.group.limit;
    }

    static class ExclusiveGroup {
        @CommandLine.Option(names={"--length", "-l"}, description={"Maximum number of items to list"}, defaultValue="100", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private int limit;
        @CommandLine.Option(names={"--all", "-a"}, description={"List all results (without pagination limit)"}, defaultValue="false")
        private boolean all;

        ExclusiveGroup() {
        }
    }
}

