/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMGetDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMGetDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMGetDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMGetDelegationTokenRequest.class);
    }

    public OMGetDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        Token<OzoneTokenIdentifier> token;
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        SecurityProtos.GetDelegationTokenRequestProto getDelegationTokenRequest = request.getGetDelegationTokenRequest();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        try {
            token = ozoneManager.getDelegationToken(new Text(getDelegationTokenRequest.getRenewer()));
        }
        catch (IOException ioe) {
            this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.GET_DELEGATION_TOKEN, new LinkedHashMap<String, String>(), ioe, request.getUserInfo()));
            throw ioe;
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = token != null ? OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder().setResponse(SecurityProtos.GetDelegationTokenResponseProto.newBuilder().setToken(OMPBHelper.protoFromToken(token)).build()).build()).setTokenRenewInterval(ozoneManager.getDelegationTokenMgr().getTokenRenewInterval())).setCmdType(request.getCmdType()).setClientId(request.getClientId()) : OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder())).setCmdType(request.getCmdType()).setClientId(request.getClientId());
        if (request.hasTraceID()) {
            omRequest.setTraceID(request.getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest updateGetDelegationTokenRequest = this.getOmRequest().getUpdateGetDelegationTokenRequest();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OMGetDelegationTokenResponse omClientResponse = null;
        if (!updateGetDelegationTokenRequest.getGetDelegationTokenResponse().hasResponse()) {
            omClientResponse = new OMGetDelegationTokenResponse(null, -1L, omResponse.setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder()).build());
            return omClientResponse;
        }
        SecurityProtos.TokenProto tokenProto = updateGetDelegationTokenRequest.getGetDelegationTokenResponse().getResponse().getToken();
        Token ozoneTokenIdentifierToken = OMPBHelper.tokenFromProto((SecurityProtos.TokenProto)tokenProto);
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = OzoneManagerUtils.buildTokenAuditMap((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken);
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        Exception exception = null;
        try {
            OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
            auditMap.put("renewer", ozoneTokenIdentifier.getRenewer() == null ? "" : ozoneTokenIdentifier.getRenewer().toString());
            long tokenRenewInterval = updateGetDelegationTokenRequest.getTokenRenewInterval();
            long renewTime = ozoneManager.getDelegationTokenMgr().updateToken((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken, ozoneTokenIdentifier, tokenRenewInterval);
            omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), CacheValue.get((long)context.getIndex(), (Object)renewTime));
            omClientResponse = new OMGetDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setGetDelegationTokenResponse(updateGetDelegationTokenRequest.getGetDelegationTokenResponse()).build());
        }
        catch (IOException | InvalidPathException ex) {
            LOG.error("Error in Updating DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
            exception = ex;
            omClientResponse = new OMGetDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.GET_DELEGATION_TOKEN, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated delegation token in-memory map: {}", (Object)ozoneTokenIdentifierToken);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMGetDelegationTokenRequest.java", OMGetDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 64);
    }
}

