/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmFSOFile;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMRecoverLeaseResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRecoverLeaseRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private String volumeName;
    private String bucketName;
    private String keyName;
    private OmKeyInfo openKeyInfo;
    private String dbOpenFileKey;
    private boolean force;
    private OMMetadataManager omMetadataManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMRecoverLeaseRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMRecoverLeaseRequest.class);
    }

    public OMRecoverLeaseRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = this.getOmRequest().getRecoverLeaseRequest();
        Preconditions.checkNotNull((Object)recoverLeaseRequest);
        this.volumeName = recoverLeaseRequest.getVolumeName();
        this.bucketName = recoverLeaseRequest.getBucketName();
        this.keyName = recoverLeaseRequest.getKeyName();
        this.force = recoverLeaseRequest.getForce();
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.HBASE_SUPPORT)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = request.getRecoverLeaseRequest();
        String keyPath = recoverLeaseRequest.getKeyName();
        String normalizedKeyPath = OMRecoverLeaseRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        this.checkKeyAcls(ozoneManager, recoverLeaseRequest.getVolumeName(), recoverLeaseRequest.getBucketName(), recoverLeaseRequest.getKeyName(), IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
        return request.toBuilder().setRecoverLeaseRequest(recoverLeaseRequest.toBuilder().setKeyName(normalizedKeyPath)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        OMClientResponse omClientResponse;
        LinkedHashMap<String, String> auditMap;
        block11: {
            OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = this.getOmRequest().getRecoverLeaseRequest();
            Preconditions.checkNotNull((Object)recoverLeaseRequest);
            auditMap = new LinkedHashMap<String, String>();
            auditMap.put("volume", this.volumeName);
            auditMap.put("bucket", this.bucketName);
            auditMap.put("key", this.keyName);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            this.omMetadataManager = ozoneManager.getMetadataManager();
            omClientResponse = null;
            exception = null;
            OMMetrics omMetrics = ozoneManager.getMetrics();
            boolean acquiredLock = false;
            try {
                try {
                    this.mergeOmLockDetails(this.omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(this.omMetadataManager, this.volumeName, this.bucketName);
                    OzoneManagerProtocolProtos.RecoverLeaseResponse recoverLeaseResponse = this.doWork(ozoneManager, context.getIndex());
                    omResponse.setRecoverLeaseResponse(recoverLeaseResponse).setCmdType(OzoneManagerProtocolProtos.Type.RecoverLease);
                    omClientResponse = new OMRecoverLeaseResponse(omResponse.build(), this.getBucketLayout(), this.dbOpenFileKey, this.openKeyInfo);
                    omMetrics.incNumRecoverLease();
                    LOG.debug("Key recovered. Volume:{}, Bucket:{}, Key:{}", new Object[]{this.volumeName, this.bucketName, this.keyName});
                }
                catch (IOException | InvalidPathException ex) {
                    LOG.error("Fail for recovering lease. Volume:{}, Bucket:{}, Key:{}", new Object[]{this.volumeName, this.bucketName, this.keyName, ex});
                    exception = ex;
                    omMetrics.incNumRecoverLeaseFails();
                    omClientResponse = new OMRecoverLeaseResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.RECOVER_LEASE, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    private OzoneManagerProtocolProtos.RecoverLeaseResponse doWork(OzoneManager ozoneManager, long transactionLogIndex) throws IOException {
        String errMsg = "Cannot recover file : " + this.keyName + " as parent directory doesn't exist";
        OmFSOFile fsoFile = new OmFSOFile.Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setOmMetadataManager(this.omMetadataManager).setErrMsg(errMsg).build();
        String dbFileKey = fsoFile.getOzonePathKey();
        OmKeyInfo keyInfo = this.getKey(dbFileKey);
        if (keyInfo == null) {
            throw new OMException("Key:" + this.keyName + " not found in keyTable.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        String writerId = (String)keyInfo.getMetadata().get("hsyncClientId");
        if (writerId == null) {
            throw new OMException("Key: " + this.keyName + " is already closed", OMException.ResultCodes.KEY_ALREADY_CLOSED);
        }
        this.dbOpenFileKey = fsoFile.getOpenFileName(Long.parseLong(writerId));
        this.openKeyInfo = (OmKeyInfo)this.omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)this.dbOpenFileKey);
        if (this.openKeyInfo == null) {
            throw new OMException("Open Key " + this.dbOpenFileKey + " not found in openKeyTable", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        if (this.openKeyInfo.getMetadata().containsKey("deletedHsyncKey")) {
            throw new OMException("Open Key " + this.keyName + " is already deleted", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        if (this.openKeyInfo.getMetadata().containsKey("leaseRecovery")) {
            LOG.debug("Key: " + this.keyName + " is already under recovery");
        } else {
            long leaseSoftLimit = ozoneManager.getConfiguration().getTimeDuration("ozone.om.lease.soft.limit", "60s", TimeUnit.MILLISECONDS);
            if (!this.force && Time.now() < this.openKeyInfo.getModificationTime() + leaseSoftLimit) {
                throw new OMException("Open Key " + this.keyName + " updated recently and is inside soft limit period", OMException.ResultCodes.KEY_UNDER_LEASE_SOFT_LIMIT_PERIOD);
            }
            this.openKeyInfo.getMetadata().put("leaseRecovery", "true");
            this.openKeyInfo.setUpdateID(transactionLogIndex);
            this.openKeyInfo.setModificationTime(Time.now());
            this.omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)this.dbOpenFileKey, (Object)this.openKeyInfo, transactionLogIndex);
        }
        keyInfo.setKeyName(this.keyName);
        this.openKeyInfo.setKeyName(this.keyName);
        OmKeyLocationInfoGroup keyLatestVersionLocations = keyInfo.getLatestVersionLocations();
        List keyLocationInfoList = keyLatestVersionLocations.getLocationList();
        OmKeyLocationInfoGroup openKeyLatestVersionLocations = this.openKeyInfo.getLatestVersionLocations();
        List openKeyLocationInfoList = openKeyLatestVersionLocations.getLocationList();
        if (!keyLocationInfoList.isEmpty()) {
            this.updateBlockInfo(ozoneManager, (OmKeyLocationInfo)keyLocationInfoList.get(keyLocationInfoList.size() - 1));
        }
        if (openKeyLocationInfoList.size() > 1) {
            this.updateBlockInfo(ozoneManager, (OmKeyLocationInfo)openKeyLocationInfoList.get(openKeyLocationInfoList.size() - 1));
            this.updateBlockInfo(ozoneManager, (OmKeyLocationInfo)openKeyLocationInfoList.get(openKeyLocationInfoList.size() - 2));
        } else if (!openKeyLocationInfoList.isEmpty()) {
            this.updateBlockInfo(ozoneManager, (OmKeyLocationInfo)openKeyLocationInfoList.get(0));
        }
        OzoneManagerProtocolProtos.RecoverLeaseResponse.Builder rb = OzoneManagerProtocolProtos.RecoverLeaseResponse.newBuilder();
        rb.setKeyInfo(keyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), true));
        rb.setOpenKeyInfo(this.openKeyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), true));
        return rb.build();
    }

    private void updateBlockInfo(OzoneManager ozoneManager, OmKeyLocationInfo blockInfo) throws IOException {
        if (blockInfo != null) {
            if (ozoneManager.isGrpcBlockTokenEnabled()) {
                String remoteUser = this.getRemoteUser().getShortUserName();
                OzoneBlockTokenSecretManager secretManager = ozoneManager.getBlockTokenSecretManager();
                blockInfo.setToken(secretManager.generateToken(remoteUser, blockInfo.getBlockID(), EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ, HddsProtos.BlockTokenSecretProto.AccessModeProto.WRITE), blockInfo.getLength()));
            }
            ContainerWithPipeline containerWithPipeline = ozoneManager.getScmClient().getContainerClient().getContainerWithPipeline(blockInfo.getContainerID());
            blockInfo.setPipeline(containerWithPipeline.getPipeline());
        }
    }

    private OmKeyInfo getKey(String dbOzoneKey) throws IOException {
        return (OmKeyInfo)this.omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbOzoneKey);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMRecoverLeaseRequest.java", OMRecoverLeaseRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMRecoverLeaseRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 98);
    }
}

