/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.Objects;
import java.util.UUID;

public class SnapshotChainInfo {
    private final UUID snapshotId;
    private UUID previousSnapshotId;
    private UUID nextSnapshotId;

    public SnapshotChainInfo(UUID snapshotID, UUID prev, UUID next) {
        this.snapshotId = snapshotID;
        this.previousSnapshotId = prev;
        this.nextSnapshotId = next;
    }

    public void setNextSnapshotId(UUID snapsID) {
        this.nextSnapshotId = snapsID;
    }

    public void setPreviousSnapshotId(UUID snapsID) {
        this.previousSnapshotId = snapsID;
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public UUID getNextSnapshotId() {
        return this.nextSnapshotId;
    }

    public boolean hasNextSnapshotId() {
        return Objects.nonNull(this.getNextSnapshotId());
    }

    public boolean hasPreviousSnapshotId() {
        return Objects.nonNull(this.getPreviousSnapshotId());
    }

    public UUID getPreviousSnapshotId() {
        return this.previousSnapshotId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotChainInfo that = (SnapshotChainInfo)o;
        return Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.previousSnapshotId, that.previousSnapshotId) && Objects.equals(this.nextSnapshotId, that.nextSnapshotId);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.previousSnapshotId, this.nextSnapshotId);
    }
}

