/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.checksum;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.container.common.helpers.TokenHelper;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class DNContainerOperationClient
implements AutoCloseable {
    private final TokenHelper tokenHelper;
    private final XceiverClientManager xceiverClientManager;

    public DNContainerOperationClient(ConfigurationSource conf, CertificateClient certificateClient, SecretKeySignerClient secretKeyClient) throws IOException {
        this.tokenHelper = new TokenHelper(new SecurityConfig(conf), secretKeyClient);
        this.xceiverClientManager = DNContainerOperationClient.createClientManager(conf, certificateClient);
    }

    @Nonnull
    private static XceiverClientManager createClientManager(ConfigurationSource conf, CertificateClient certificateClient) throws IOException {
        ClientTrustManager trustManager = null;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            trustManager = certificateClient.createClientTrustManager();
        }
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)conf.getObject(DatanodeConfiguration.class));
        return new XceiverClientManager(conf, new XceiverClientManager.XceiverClientManagerConfigBuilder().setMaxCacheSize(dnConf.getContainerClientCacheSize()).setStaleThresholdMs((long)dnConf.getContainerClientCacheStaleThreshold()).build(), trustManager);
    }

    public XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public TokenHelper getTokenHelper() {
        return this.tokenHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerProtos.ContainerChecksumInfo getContainerChecksumInfo(long containerId, DatanodeDetails dn) throws IOException {
        XceiverClientSpi xceiverClient = this.xceiverClientManager.acquireClient(DNContainerOperationClient.createSingleNodePipeline(dn));
        try {
            String containerToken = TokenHelper.encode(this.tokenHelper.getContainerToken(ContainerID.valueOf((long)containerId)));
            ContainerProtos.GetContainerChecksumInfoResponseProto response = ContainerProtocolCalls.getContainerChecksumInfo((XceiverClientSpi)xceiverClient, (long)containerId, (String)containerToken);
            ByteString serializedChecksumInfo = response.getContainerChecksumInfo();
            if (serializedChecksumInfo.isEmpty()) {
                throw new StorageContainerException("Empty Container checksum file for container " + containerId + " received", ContainerProtos.Result.IO_EXCEPTION);
            }
            ContainerProtos.ContainerChecksumInfo containerChecksumInfo = ContainerProtos.ContainerChecksumInfo.parseFrom((ByteString)serializedChecksumInfo);
            return containerChecksumInfo;
        }
        finally {
            this.xceiverClientManager.releaseClient(xceiverClient, false);
        }
    }

    public static Pipeline createSingleNodePipeline(DatanodeDetails dn) {
        return Pipeline.newBuilder().setNodes((List)ImmutableList.of((Object)dn)).setId(PipelineID.valueOf((UUID)dn.getUuid())).setState(Pipeline.PipelineState.CLOSED).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)).build();
    }

    @Override
    public void close() throws IOException {
        if (this.xceiverClientManager != null) {
            this.xceiverClientManager.close();
        }
    }
}

