/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jooq.AggregateFunction;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.CaseConditionStep;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.OrderedAggregateFunction;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.WindowBeforeOverStep;
import org.jooq.WindowDefinition;
import org.jooq.WindowFinalStep;
import org.jooq.WindowFromFirstLastStep;
import org.jooq.WindowOrderByStep;
import org.jooq.WindowPartitionByStep;
import org.jooq.WindowRowsAndStep;
import org.jooq.WindowRowsStep;
import org.jooq.WindowSpecification;
import org.jooq.impl.AbstractField;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Term;
import org.jooq.impl.Tools;
import org.jooq.impl.WindowDefinitionImpl;
import org.jooq.impl.WindowSpecificationImpl;

class Function<T>
extends AbstractField<T>
implements OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T>,
AggregateFunction<T>,
WindowFromFirstLastStep<T>,
WindowPartitionByStep<T>,
WindowRowsStep<T>,
WindowRowsAndStep<T> {
    private static final long serialVersionUID = 347252741712134044L;
    private static final EnumSet<SQLDialect> SUPPORT_ARRAY_AGG = EnumSet.of(SQLDialect.HSQLDB, SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> SUPPORT_GROUP_CONCAT = EnumSet.of(SQLDialect.CUBRID, new SQLDialect[]{SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE});
    private static final EnumSet<SQLDialect> SUPPORT_STRING_AGG = EnumSet.of(SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> SUPPORT_WINDOW_CLAUSE = EnumSet.of(SQLDialect.MYSQL, SQLDialect.POSTGRES);
    static final Field<Integer> ASTERISK = DSL.field("*", Integer.class);
    private final Name name;
    private final Term term;
    private final QueryPartList<QueryPart> arguments;
    private final boolean distinct;
    private SortFieldList withinGroupOrderBy;
    private SortFieldList keepDenseRankOrderBy;
    private Condition filter;
    private WindowSpecificationImpl windowSpecification;
    private WindowDefinitionImpl windowDefinition;
    private Name windowName;
    private boolean first;
    private Boolean ignoreNulls;
    private Boolean fromLast;

    Function(String name, DataType<T> type, QueryPart ... arguments) {
        this(name, false, type, arguments);
    }

    Function(Term term, DataType<T> type, QueryPart ... arguments) {
        this(term, false, type, arguments);
    }

    Function(Name name, DataType<T> type, QueryPart ... arguments) {
        this(name, false, type, arguments);
    }

    Function(String name, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(DSL.name(name), type);
        this.term = null;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
    }

    Function(Term term, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(term.toName(), type);
        this.term = term;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
    }

    Function(Name name, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(name, type);
        this.term = null;
        this.name = name;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
    }

    @Override
    public void accept(Context<?> ctx) {
        if (this.term == Term.ARRAY_AGG && SUPPORT_ARRAY_AGG.contains((Object)ctx.family())) {
            this.toSQLGroupConcat(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        } else if (this.term == Term.LIST_AGG && SUPPORT_GROUP_CONCAT.contains((Object)ctx.family())) {
            this.toSQLGroupConcat(ctx);
        } else if (this.term == Term.LIST_AGG && SUPPORT_STRING_AGG.contains((Object)ctx.family())) {
            this.toSQLStringAgg(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        } else if (this.term == Term.MEDIAN && ctx.family() == SQLDialect.POSTGRES) {
            Field[] fields = new Field[this.arguments.size()];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = DSL.field("{0}", new QueryPart[]{this.arguments.get(i)});
            }
            ctx.visit(DSL.percentileCont(new BigDecimal("0.5")).withinGroupOrderBy(fields));
        } else {
            this.toSQLArguments(ctx);
            this.toSQLKeepDenseRankOrderByClause(ctx);
            this.toSQLWithinGroupClause(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        }
    }

    final void toSQLStringAgg(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
        }
        ctx.visit(((Field)this.arguments.get(0)).cast(String.class));
        if (this.arguments.size() > 1) {
            ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
        } else {
            ctx.sql(", ''");
        }
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
        ctx.sql(')');
    }

    final void toSQLGroupConcat(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        this.toSQLArguments1(ctx, new QueryPartList<QueryPart>(Arrays.asList(this.arguments.get(0))));
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
        if (this.arguments.size() > 1) {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
            } else {
                ctx.sql(' ').visit(Keywords.K_SEPARATOR).sql(' ').visit((QueryPart)this.arguments.get(1));
            }
        }
        ctx.sql(')');
    }

    final void toSQLFilterClause(Context<?> ctx) {
        if (this.filter != null && (SQLDialect.HSQLDB == ctx.family() || SQLDialect.POSTGRES_9_4.precedes(ctx.dialect()))) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(this.filter).sql(')');
        }
    }

    final void toSQLOverClause(Context<?> ctx) {
        QueryPart window = this.window(ctx);
        if (window == null) {
            return;
        }
        if (this.term == Term.ROW_NUMBER && ctx.configuration().dialect() == SQLDialect.HSQLDB) {
            return;
        }
        ctx.sql(' ').visit(Keywords.K_OVER).sql(' ').visit(window);
    }

    final QueryPart window(Context<?> ctx) {
        if (this.windowSpecification != null) {
            return DSL.sql("({0})", this.windowSpecification);
        }
        if (this.windowDefinition != null) {
            if (SQLDialect.POSTGRES == ctx.family()) {
                return this.windowDefinition;
            }
            return DSL.sql("({0})", this.windowDefinition);
        }
        if (this.windowName != null) {
            if (SUPPORT_WINDOW_CLAUSE.contains((Object)ctx.family())) {
                return this.windowName;
            }
            QueryPartList windows = (QueryPartList)ctx.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS);
            if (windows != null) {
                for (WindowDefinition window : windows) {
                    if (!((WindowDefinitionImpl)window).getName().equals(this.windowName)) continue;
                    return DSL.sql("({0})", window);
                }
            } else {
                return this.windowName;
            }
        }
        return null;
    }

    final void toSQLKeepDenseRankOrderByClause(Context<?> ctx) {
        if (!Tools.isEmpty(this.keepDenseRankOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_KEEP).sql(" (").visit(Keywords.K_DENSE_RANK).sql(' ').visit(this.first ? Keywords.K_FIRST : Keywords.K_LAST).sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.keepDenseRankOrderBy).sql(')');
        }
    }

    final void toSQLWithinGroupClause(Context<?> ctx) {
        if (this.withinGroupOrderBy != null) {
            ctx.sql(' ').visit(Keywords.K_WITHIN_GROUP).sql(" (").visit(Keywords.K_ORDER_BY).sql(' ');
            if (this.withinGroupOrderBy.isEmpty()) {
                ctx.visit(Keywords.K_NULL);
            } else {
                ctx.visit(this.withinGroupOrderBy);
            }
            ctx.sql(')');
        }
    }

    final void toSQLArguments(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        this.toSQLArguments0(ctx);
        ctx.sql(')');
    }

    final void toSQLArguments0(Context<?> ctx) {
        this.toSQLArguments1(ctx, this.arguments);
    }

    final void toSQLArguments1(Context<?> ctx, QueryPartList<QueryPart> args) {
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT);
            if (ctx.family() == SQLDialect.POSTGRES && args.size() > 1) {
                ctx.sql('(');
            } else {
                ctx.sql(' ');
            }
        }
        if (!args.isEmpty()) {
            if (this.filter == null || SQLDialect.HSQLDB == ctx.family() || SQLDialect.POSTGRES_9_4.precedes(ctx.dialect())) {
                ctx.visit(args);
            } else {
                QueryPartList<CaseConditionStep<Param<Integer>>> expressions = new QueryPartList<CaseConditionStep<Param<Integer>>>();
                for (QueryPart argument : args) {
                    expressions.add(DSL.when(this.filter, argument == ASTERISK ? DSL.one() : argument));
                }
                ctx.visit(expressions);
            }
        }
        if (this.distinct && ctx.family() == SQLDialect.POSTGRES && args.size() > 1) {
            ctx.sql(')');
        }
    }

    final void toSQLFunctionName(Context<?> ctx) {
        if (this.name != null) {
            ctx.visit(this.name);
        } else if (this.term != null) {
            ctx.sql(this.term.translate(ctx.configuration().dialect()));
        } else {
            ctx.sql(this.getName());
        }
    }

    final QueryPartList<QueryPart> getArguments() {
        return this.arguments;
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields) {
        return this.withinGroupOrderBy(Arrays.asList(fields));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c) {
        this.filter = c;
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(Arrays.asList(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        ConditionProviderImpl c = new ConditionProviderImpl();
        c.addConditions(conditions);
        return this.filterWhere((Condition)c);
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Boolean field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final WindowPartitionByStep<T> over() {
        this.windowSpecification = new WindowSpecificationImpl();
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(WindowSpecification specification) {
        this.windowSpecification = (WindowSpecificationImpl)specification;
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(WindowDefinition definition) {
        this.windowDefinition = (WindowDefinitionImpl)definition;
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(String n) {
        return this.over(DSL.name(n));
    }

    @Override
    public final WindowFinalStep<T> over(Name n) {
        this.windowName = n;
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionBy(Field<?> ... fields) {
        this.windowSpecification.partitionBy((Field[])fields);
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionBy(Collection<? extends Field<?>> fields) {
        this.windowSpecification.partitionBy((Collection)fields);
        return this;
    }

    @Override
    @Deprecated
    public final WindowOrderByStep<T> partitionByOne() {
        this.windowSpecification.partitionByOne();
        return this;
    }

    @Override
    public final Function<T> orderBy(OrderField<?> ... fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((OrderField[])fields);
        } else {
            this.withinGroupOrderBy((OrderField[])fields);
        }
        return this;
    }

    @Override
    public final Function<T> orderBy(Collection<? extends OrderField<?>> fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields);
        } else {
            this.withinGroupOrderBy((Collection)fields);
        }
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsUnboundedPreceding() {
        this.windowSpecification.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsPreceding(int number) {
        this.windowSpecification.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsCurrentRow() {
        this.windowSpecification.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsUnboundedFollowing() {
        this.windowSpecification.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsFollowing(int number) {
        this.windowSpecification.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedPreceding() {
        this.windowSpecification.rowsBetweenUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenPreceding(int number) {
        this.windowSpecification.rowsBetweenPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenCurrentRow() {
        this.windowSpecification.rowsBetweenCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedFollowing() {
        this.windowSpecification.rowsBetweenUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenFollowing(int number) {
        this.windowSpecification.rowsBetweenFollowing(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> rangeUnboundedPreceding() {
        this.windowSpecification.rangeUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rangePreceding(int number) {
        this.windowSpecification.rangePreceding(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> rangeCurrentRow() {
        this.windowSpecification.rangeCurrentRow();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rangeUnboundedFollowing() {
        this.windowSpecification.rangeUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowFinalStep<T> rangeFollowing(int number) {
        this.windowSpecification.rangeFollowing(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenUnboundedPreceding() {
        this.windowSpecification.rangeBetweenUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenPreceding(int number) {
        this.windowSpecification.rangeBetweenPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenCurrentRow() {
        this.windowSpecification.rangeBetweenCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenUnboundedFollowing() {
        this.windowSpecification.rangeBetweenUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenFollowing(int number) {
        this.windowSpecification.rangeBetweenFollowing(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> andUnboundedPreceding() {
        this.windowSpecification.andUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowFinalStep<T> andPreceding(int number) {
        this.windowSpecification.andPreceding(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> andCurrentRow() {
        this.windowSpecification.andCurrentRow();
        return this;
    }

    @Override
    public final WindowFinalStep<T> andUnboundedFollowing() {
        this.windowSpecification.andUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowFinalStep<T> andFollowing(int number) {
        this.windowSpecification.andFollowing(number);
        return this;
    }
}

