/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class VersionInfo {
    private final Properties info = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = ThreadUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)versionInfoFile);
            this.info.load(is);
        }
        catch (IOException ex) {
            try {
                LoggerFactory.getLogger(this.getClass()).warn("Could not read '" + versionInfoFile + "', " + ex.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(is);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)is);
        }
        IOUtils.closeStream((Closeable)is);
    }

    public String getRelease() {
        return this.info.getProperty("release", "Unknown");
    }

    public String getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    public String getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    public String getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    public String getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    public String getProtoVersions() {
        return this.info.getProperty("protoVersions", "Unknown");
    }

    public String getCompilePlatform() {
        return this.info.getProperty("compilePlatform", "Unknown");
    }

    public String getBuildVersion() {
        return this.getVersion() + " from " + this.getRevision() + " source checksum " + this.getSrcChecksum();
    }
}

