/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.krb.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketCacheConfiguration
extends Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketCacheConfiguration.class);
    private final String principal;
    private final String ticketCache;
    private final AppConfigurationEntry ticketCacheConfigEntry;

    public TicketCacheConfiguration(String principal) {
        this(principal, null);
    }

    public TicketCacheConfiguration(String principal, String ticketCache) {
        if (StringUtils.isBlank((CharSequence)principal)) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        this.principal = principal;
        this.ticketCache = ticketCache;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", principal);
        options.put("refreshKrb5Config", "true");
        options.put("useTicketCache", "true");
        if (StringUtils.isNotBlank((CharSequence)ticketCache)) {
            options.put("ticketCache", ticketCache);
        }
        String krbLoginModuleName = ConfigurationUtil.IS_IBM ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        LOGGER.debug("krbLoginModuleName: {}, configuration options: {}", (Object)krbLoginModuleName, options);
        this.ticketCacheConfigEntry = new AppConfigurationEntry(krbLoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{this.ticketCacheConfigEntry};
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getTicketCache() {
        return this.ticketCache;
    }
}

