/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class ProvenanceRepositorySchema
extends BaseSchema
implements WritableSchema {
    public static final String PROVENANCE_REPO_ROLLOVER_TIME_KEY = "provenance rollover time";
    public static final String PROVENANCE_REPO_INDEX_SHARD_SIZE = "provenance index shard size";
    public static final String PROVENANCE_REPO_MAX_STORAGE_SIZE = "provenance max storage size";
    public static final String PROVENANCE_REPO_MAX_STORAGE_TIME = "provenance max storage time";
    public static final String DEFAULT_PROVENANCE_ROLLOVER_TIME = "1 min";
    public static final String PROVENANCE_REPOSITORY_KEY = "implementation";
    public static final String DEFAULT_PROVENANCE_REPOSITORY = "org.apache.nifi.provenance.WriteAheadProvenanceRepository";
    public static final String DEFAULT_PROVENANCE_REPO_INDEX_SHARD_SIZE = "500 MB";
    public static final String DEFAULT_PROVENANCE_REPO_MAX_STORAGE_SIZE = "1 GB";
    public static final String DEFAULT_PROVENANCE_REPO_MAX_STORAGE_TIME = "24 hours";
    public static final String PROVENANCE_REPO_BUFFER_SIZE = "provenance buffer size";
    public static final Integer DEFAULT_PROVENANCE_REPO_BUFFER_SIZE = 10000;
    private String provenanceRepoRolloverTime = "1 min";
    private String provenanceRepository = "org.apache.nifi.provenance.WriteAheadProvenanceRepository";
    private String provenanceRepoIndexShardSize = "500 MB";
    private String provenanceRepoMaxStorageSize = "1 GB";
    private String provenanceRepoMaxStorageTime = "24 hours";
    private Integer provenanceRepoBufferSize = DEFAULT_PROVENANCE_REPO_BUFFER_SIZE;

    public ProvenanceRepositorySchema() {
    }

    public ProvenanceRepositorySchema(Map map) {
        this.provenanceRepoRolloverTime = this.getOptionalKeyAsType(map, PROVENANCE_REPO_ROLLOVER_TIME_KEY, String.class, "Provenance Repository", DEFAULT_PROVENANCE_ROLLOVER_TIME);
        this.provenanceRepository = this.getOptionalKeyAsType(map, PROVENANCE_REPOSITORY_KEY, String.class, "Provenance Repository", DEFAULT_PROVENANCE_REPOSITORY);
        this.provenanceRepoIndexShardSize = this.getOptionalKeyAsType(map, PROVENANCE_REPO_INDEX_SHARD_SIZE, String.class, "Provenance Repository", DEFAULT_PROVENANCE_REPO_INDEX_SHARD_SIZE);
        this.provenanceRepoMaxStorageSize = this.getOptionalKeyAsType(map, PROVENANCE_REPO_MAX_STORAGE_SIZE, String.class, "Provenance Repository", DEFAULT_PROVENANCE_REPO_MAX_STORAGE_SIZE);
        this.provenanceRepoMaxStorageTime = this.getOptionalKeyAsType(map, PROVENANCE_REPO_MAX_STORAGE_TIME, String.class, "Provenance Repository", DEFAULT_PROVENANCE_REPO_MAX_STORAGE_TIME);
        this.provenanceRepoBufferSize = this.getOptionalKeyAsType(map, PROVENANCE_REPO_BUFFER_SIZE, Integer.class, "Provenance Repository", DEFAULT_PROVENANCE_REPO_BUFFER_SIZE);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(PROVENANCE_REPO_ROLLOVER_TIME_KEY, this.provenanceRepoRolloverTime);
        result.put(PROVENANCE_REPOSITORY_KEY, this.provenanceRepository);
        result.put(PROVENANCE_REPO_INDEX_SHARD_SIZE, this.provenanceRepoIndexShardSize);
        result.put(PROVENANCE_REPO_MAX_STORAGE_SIZE, this.provenanceRepoMaxStorageSize);
        result.put(PROVENANCE_REPO_MAX_STORAGE_TIME, this.provenanceRepoMaxStorageTime);
        result.put(PROVENANCE_REPO_BUFFER_SIZE, this.provenanceRepoBufferSize);
        return result;
    }

    public String getProvenanceRepository() {
        return this.provenanceRepository;
    }

    public String getProvenanceRepoRolloverTimeKey() {
        return this.provenanceRepoRolloverTime;
    }

    public String getProvenanceRepoIndexShardSize() {
        return this.provenanceRepoIndexShardSize;
    }

    public String getProvenanceRepoMaxStorageSize() {
        return this.provenanceRepoMaxStorageSize;
    }

    public String getProvenanceRepoMaxStorageTime() {
        return this.provenanceRepoMaxStorageTime;
    }

    public int getProvenanceRepoBufferSize() {
        return this.provenanceRepoBufferSize;
    }
}

