/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.events.ComponentBulletin;
import org.apache.nifi.events.SystemBulletin;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.ComponentType;

public final class BulletinFactory {
    private static final AtomicLong currentId = new AtomicLong(0L);

    private BulletinFactory() {
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message) {
        ComponentType type = BulletinFactory.getComponentType(connectable);
        ProcessGroup group = connectable.getProcessGroup();
        String groupId = connectable.getProcessGroupIdentifier();
        String groupName = group == null ? null : group.getName();
        String groupPath = BulletinFactory.buildGroupPath(group);
        return BulletinFactory.createBulletin(groupId, groupName, connectable.getIdentifier(), type, connectable.getName(), category, severity, message, groupPath, null);
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message, String flowFileUUID) {
        ComponentType type = BulletinFactory.getComponentType(connectable);
        ProcessGroup group = connectable.getProcessGroup();
        String groupId = connectable.getProcessGroupIdentifier();
        String groupName = group == null ? null : group.getName();
        String groupPath = BulletinFactory.buildGroupPath(group);
        return BulletinFactory.createBulletin(groupId, groupName, connectable.getIdentifier(), type, connectable.getName(), category, severity, message, groupPath, flowFileUUID);
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message, String flowFileUUID, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(connectable, category, severity, message, flowFileUUID);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    public static Bulletin createBulletin(Connectable connectable, String category, String severity, String message, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(connectable, category, severity, message);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    private static String buildGroupPath(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        StringBuilder path = new StringBuilder(group.getName());
        for (ProcessGroup parent = group.getParent(); parent != null; parent = parent.getParent()) {
            path.insert(0, " / ");
            path.insert(0, parent.getName());
        }
        return path.toString();
    }

    public static Bulletin createBulletin(String groupId, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(groupId, sourceId, sourceType, sourceName, category, severity, message);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setGroupName(groupName);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(groupId, groupName, sourceId, sourceType, sourceName, category, severity, message);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message, String groupPath, String flowFileUUID) {
        ComponentBulletin bulletin = new ComponentBulletin(currentId.getAndIncrement());
        bulletin.setGroupId(groupId);
        bulletin.setGroupName(groupName);
        bulletin.setGroupPath(groupPath);
        bulletin.setSourceId(sourceId);
        bulletin.setSourceType(sourceType);
        bulletin.setSourceName(sourceName);
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        bulletin.setFlowFileUuid(flowFileUUID);
        return bulletin;
    }

    public static Bulletin createBulletin(String groupId, String groupName, String sourceId, ComponentType sourceType, String sourceName, String category, String severity, String message, String groupPath, String flowFileUUID, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(groupId, groupName, sourceId, sourceType, sourceName, category, severity, message, groupPath, flowFileUUID);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    public static Bulletin createBulletin(String category, String severity, String message) {
        SystemBulletin bulletin = new SystemBulletin(currentId.getAndIncrement());
        bulletin.setCategory(category);
        bulletin.setLevel(severity);
        bulletin.setMessage(message);
        bulletin.setSourceType(ComponentType.FLOW_CONTROLLER);
        return bulletin;
    }

    public static Bulletin createBulletin(String category, String severity, String message, Throwable t) {
        Bulletin bulletin = BulletinFactory.createBulletin(category, severity, message);
        if (t != null) {
            bulletin.setStackTrace(BulletinFactory.formatStackTrace(t));
        }
        return bulletin;
    }

    private static ComponentType getComponentType(Connectable connectable) {
        return switch (connectable.getConnectableType()) {
            case ConnectableType.REMOTE_INPUT_PORT, ConnectableType.REMOTE_OUTPUT_PORT -> ComponentType.REMOTE_PROCESS_GROUP;
            case ConnectableType.INPUT_PORT -> ComponentType.INPUT_PORT;
            case ConnectableType.OUTPUT_PORT -> ComponentType.OUTPUT_PORT;
            case ConnectableType.STATELESS_GROUP -> ComponentType.PROCESS_GROUP;
            default -> ComponentType.PROCESSOR;
        };
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String formatStackTrace(Throwable t) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                pw.flush();
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return t.toString();
        }
    }
}

