/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;

/**
 * Panel for display the run-as element of the servlet deployment descriptor.
 * @author  ptliu
 */
public class RunAsPanel extends javax.swing.JPanel {
    private WebApp webApp;
    
    /** Creates new form RunAsPanel */
    public RunAsPanel(final WebApp webApp) {
        initComponents();
        
        this.webApp = webApp;
        
        webApp.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent event) {
                //System.out.println("source = " + event.getSource());
                
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                
                //System.out.println("oldValue = " + oldValue);
                //System.out.println("newValue = " + newValue);
                
                String selectedItem = (String) runAsCB.getSelectedItem();
                if (oldValue instanceof SecurityRole ||
                        newValue instanceof SecurityRole) {
                    initModel(webApp.getSecurityRole());
                }
                runAsCB.setSelectedItem(selectedItem);
            }
        });
        
        initModel(webApp.getSecurityRole());
    }
    
    private void initModel(SecurityRole[] roles) {
        String[] roleNames = new String[roles.length+1];
        roleNames[0] = "";      //NOI18N
        
        for (int i = 0; i < roles.length; i++) {
            roleNames[i+1] = roles[i].getRoleName();
        }
        runAsCB.setModel(new DefaultComboBoxModel(roleNames));
        
        runAsCB.setSelectedIndex(0);      
    }
    
    public String getRunAs() {
        return (String) runAsCB.getSelectedItem();
    }
    
    public JComboBox getRunAsCB() {
        return runAsCB;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        runAsLabel = new javax.swing.JLabel();
        runAsCB = new javax.swing.JComboBox();

        setOpaque(false);

        runAsLabel.setLabelFor(runAsCB);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(runAsLabel, bundle.getString("LBL_RunAs")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(runAsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(runAsCB, 0, 358, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(runAsLabel)
                    .addComponent(runAsCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox runAsCB;
    private javax.swing.JLabel runAsLabel;
    // End of variables declaration//GEN-END:variables
    
}
