/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.embed;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.classworlds.ClassWorldReverseAdapter;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.EmbedderException;
import org.codehaus.plexus.embed.PlexusEmbedder;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PropertyUtils;

public class Embedder
implements PlexusEmbedder {
    private URL configurationUrl;
    private Properties properties;
    private DefaultPlexusContainer container;
    private boolean embedderStarted = false;
    private boolean embedderStopped = false;
    private Map context = new HashMap();

    public Embedder() {
    }

    public Embedder(Map context, String configuration) throws EmbedderException {
        this(context, configuration, null);
    }

    public Embedder(Map context, String configuration, org.codehaus.classworlds.ClassWorld classWorld) throws EmbedderException {
        try {
            this.container = classWorld == null ? new DefaultPlexusContainer("plexus", context, configuration, null) : new DefaultPlexusContainer("plexus", context, configuration, (ClassWorld)ClassWorldReverseAdapter.getInstance((org.codehaus.classworlds.ClassWorld)classWorld));
            this.embedderStarted = true;
        }
        catch (PlexusContainerException e) {
            throw new EmbedderException("Error creating embedder. " + e.getMessage(), e);
        }
    }

    public synchronized PlexusContainer getContainer() {
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder must be started");
        }
        return this.container;
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    public Object lookup(String role, String id) throws ComponentLookupException {
        return this.getContainer().lookup(role, id);
    }

    public boolean hasComponent(String role) {
        return this.getContainer().hasComponent(role);
    }

    public boolean hasComponent(String role, String id) {
        return this.getContainer().hasComponent(role, id);
    }

    public void release(Object service) throws ComponentLifecycleException {
        this.getContainer().release(service);
    }

    public synchronized void setClassWorld(org.codehaus.classworlds.ClassWorld classWorld) {
        this.container.setClassWorld((ClassWorld)ClassWorldReverseAdapter.getInstance((org.codehaus.classworlds.ClassWorld)classWorld));
    }

    public synchronized void setConfiguration(URL configuration) throws IOException {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.configurationUrl = configuration;
    }

    public synchronized void setConfiguration(Reader configuration) throws IOException {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        File tempFile = File.createTempFile("plexus-embedder", "");
        tempFile.deleteOnExit();
        FileWriter writer = null;
        try {
            writer = new FileWriter(tempFile);
            IOUtil.copy((Reader)configuration, (Writer)writer);
            this.configurationUrl = tempFile.toURL();
        }
        catch (IOException e) {
            IOUtil.close(writer);
        }
    }

    public synchronized void addContextValue(Object key, Object value) {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.context.put(key, value);
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
    }

    public synchronized void setProperties(File file) {
        this.properties = PropertyUtils.loadProperties((File)file);
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.container.setLoggerManager(loggerManager);
    }

    protected synchronized void initializeContext() {
        Set keys = ((Hashtable)this.properties).keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = this.properties.getProperty(key);
            this.context.put(key, value);
        }
    }

    public synchronized void start(org.codehaus.classworlds.ClassWorld classWorld) throws PlexusContainerException {
        this.container.setClassWorld((ClassWorld)ClassWorldReverseAdapter.getInstance((org.codehaus.classworlds.ClassWorld)classWorld));
        this.start();
    }

    public synchronized void start() throws PlexusContainerException {
        if (this.embedderStarted) {
            throw new IllegalStateException("Embedder already started");
        }
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder cannot be restarted");
        }
        if (this.properties != null) {
            this.initializeContext();
        }
        this.container = new DefaultPlexusContainer(null, this.context, this.configurationUrl, null);
        this.embedderStarted = true;
    }

    public synchronized void stop() {
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder already stopped");
        }
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder not started");
        }
        this.container.dispose();
        this.embedderStarted = false;
        this.embedderStopped = true;
    }
}

