/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public final class AssertingAcceptDocs
extends AcceptDocs {
    private final AcceptDocs acceptDocs;
    private final Thread creationThread = Thread.currentThread();

    public static AcceptDocs wrap(AcceptDocs acceptDocs) {
        if (acceptDocs instanceof AssertingAcceptDocs) {
            AssertingAcceptDocs assertingAcceptDocs = (AssertingAcceptDocs)acceptDocs;
            return assertingAcceptDocs;
        }
        return new AssertingAcceptDocs(acceptDocs);
    }

    private AssertingAcceptDocs(AcceptDocs acceptDocs) {
        this.acceptDocs = acceptDocs;
    }

    public Bits bits() throws IOException {
        assert (Thread.currentThread() == this.creationThread) : "Usage of AcceptDocs should be confined to a single thread";
        return this.acceptDocs.bits();
    }

    public DocIdSetIterator iterator() throws IOException {
        assert (Thread.currentThread() == this.creationThread) : "Usage of AcceptDocs should be confined to a single thread";
        DocIdSetIterator iterator = this.acceptDocs.iterator();
        assert (iterator.docID() == -1) : "Iterator must be unpositioned";
        return iterator;
    }

    public int cost() throws IOException {
        assert (Thread.currentThread() == this.creationThread) : "Usage of AcceptDocs should be confined to a single thread";
        return this.acceptDocs.cost();
    }
}

