/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kyuubi.shade.io.netty.handler.ssl.OpenSsl;
import org.apache.kyuubi.shade.io.netty.handler.ssl.SslProvider;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.VertxException;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.http.ClientAuth;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.net.ClientOptionsBase;
import org.apache.kyuubi.shade.io.vertx.core.net.JdkSSLEngineOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.KeyCertOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.NetClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.OpenSSLEngineOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SSLEngineOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SSLOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.TCPSSLOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.TrustOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SslChannelProvider;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SslContextProvider;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SslContextUpdate;
import org.apache.kyuubi.shade.io.vertx.core.spi.tls.DefaultSslContextFactory;
import org.apache.kyuubi.shade.io.vertx.core.spi.tls.SslContextFactory;

public class SSLHelper {
    private static final AtomicLong seq = new AtomicLong();
    static final EnumMap<ClientAuth, org.apache.kyuubi.shade.io.netty.handler.ssl.ClientAuth> CLIENT_AUTH_MAPPING = new EnumMap(ClientAuth.class);
    private final boolean ssl;
    private final boolean sni;
    private final boolean trustAll;
    private final ClientAuth clientAuth;
    private final boolean client;
    private final boolean useAlpn;
    private final String endpointIdentificationAlgorithm;
    private final SSLEngineOptions sslEngineOptions;
    private final List<String> applicationProtocols;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private Function<String, KeyManagerFactory> keyManagerFactoryMapper;
    private Function<String, TrustManager[]> trustManagerMapper;
    private List<CRL> crls;
    private Future<CachedProvider> cachedProvider;

    public static SSLEngineOptions resolveEngineOptions(SSLEngineOptions engineOptions, boolean useAlpn) {
        if (engineOptions == null && useAlpn) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSsl.isAvailable()) {
            VertxException ex = new VertxException("OpenSSL is not available");
            Throwable cause = OpenSsl.unavailabilityCause();
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
        if (useAlpn) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public SSLHelper(TCPSSLOptions options, List<String> applicationProtocols) {
        this.sslEngineOptions = options.getSslEngineOptions();
        this.ssl = options.isSsl();
        this.useAlpn = options.isUseAlpn();
        this.client = options instanceof ClientOptionsBase;
        this.trustAll = options instanceof ClientOptionsBase && ((ClientOptionsBase)options).isTrustAll();
        this.clientAuth = options instanceof NetServerOptions ? ((NetServerOptions)options).getClientAuth() : ClientAuth.NONE;
        this.endpointIdentificationAlgorithm = options instanceof NetClientOptions ? ((NetClientOptions)options).getHostnameVerificationAlgorithm() : "";
        this.sni = options instanceof NetServerOptions && ((NetServerOptions)options).isSni();
        this.applicationProtocols = applicationProtocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<SslContextUpdate> updateSslContext(SSLOptions options, boolean force, ContextInternal ctx) {
        long id = seq.getAndIncrement();
        SSLHelper sSLHelper = this;
        synchronized (sSLHelper) {
            this.cachedProvider = this.cachedProvider == null ? this.buildChannelProvider(options, ctx).map(a -> new CachedProvider(options, id, (SslChannelProvider)a, null)) : this.cachedProvider.transform(prev -> {
                if (!force && prev.succeeded() && ((CachedProvider)prev.result()).options.equals(options)) {
                    return Future.succeededFuture(prev.result());
                }
                return this.buildChannelProvider(options, ctx).transform(ar -> {
                    if (ar.succeeded()) {
                        return ctx.succeededFuture(new CachedProvider(options, id, (SslChannelProvider)ar.result(), null));
                    }
                    if (prev.succeeded()) {
                        return ctx.succeededFuture(new CachedProvider(((CachedProvider)prev.result()).options, ((CachedProvider)prev.result()).id, ((CachedProvider)prev.result()).sslChannelProvider, ar.cause()));
                    }
                    return ctx.failedFuture(prev.cause());
                });
            });
            return this.cachedProvider.map(c -> new SslContextUpdate(c.sslChannelProvider, c.id == id, c.failure));
        }
    }

    public Future<SslContextProvider> buildContextProvider(SSLOptions sslOptions, ContextInternal ctx) {
        return this.build(new SSLOptions(sslOptions), ctx).map(EngineConfig::sslContextProvider);
    }

    public Future<SslChannelProvider> buildChannelProvider(SSLOptions sslOptions, ContextInternal ctx) {
        return this.build(new SSLOptions(sslOptions), ctx).map(c -> new SslChannelProvider(c.sslContextProvider(), ((EngineConfig)c).sslOptions.getSslHandshakeTimeout(), ((EngineConfig)c).sslOptions.getSslHandshakeTimeoutUnit(), this.sni, this.trustAll, this.useAlpn, ctx.owner().getInternalWorkerPool().executor(), ((EngineConfig)c).useWorkerPool));
    }

    private Future<EngineConfig> build(SSLOptions sslOptions, ContextInternal ctx) {
        Future<EngineConfig> sslContextFactorySupplier;
        KeyCertOptions keyCertOptions = sslOptions.getKeyCertOptions();
        TrustOptions trustOptions = sslOptions.getTrustOptions();
        if (keyCertOptions != null || trustOptions != null || this.trustAll || this.ssl) {
            Promise promise = Promise.promise();
            sslContextFactorySupplier = promise.future();
            ctx.executeBlockingInternal(p -> {
                try {
                    if (sslOptions.getKeyCertOptions() != null) {
                        this.keyManagerFactory = sslOptions.getKeyCertOptions().getKeyManagerFactory(ctx.owner());
                        this.keyManagerFactoryMapper = sslOptions.getKeyCertOptions().keyManagerFactoryMapper(ctx.owner());
                    }
                    if (sslOptions.getTrustOptions() != null) {
                        this.trustManagerFactory = sslOptions.getTrustOptions().getTrustManagerFactory(ctx.owner());
                        this.trustManagerMapper = sslOptions.getTrustOptions().trustManagerMapper(ctx.owner());
                    }
                    this.crls = new ArrayList<CRL>();
                    ArrayList<Buffer> tmp = new ArrayList<Buffer>();
                    if (sslOptions.getCrlPaths() != null) {
                        tmp.addAll(sslOptions.getCrlPaths().stream().map(path -> ctx.owner().resolveFile((String)path).getAbsolutePath()).map(ctx.owner().fileSystem()::readFileBlocking).collect(Collectors.toList()));
                    }
                    if (sslOptions.getCrlValues() != null) {
                        tmp.addAll(sslOptions.getCrlValues());
                    }
                    CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
                    for (Buffer crlValue : tmp) {
                        this.crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
                    }
                }
                catch (Exception e) {
                    p.fail(e);
                    return;
                }
                if (this.client || sslOptions.getKeyCertOptions() != null) {
                    p.complete();
                } else {
                    p.fail("Key/certificate is mandatory for SSL");
                }
            }).compose(v2 -> ctx.executeBlockingInternal(p -> {
                boolean useWorkerPool;
                Supplier<SslContextFactory> supplier;
                try {
                    SSLEngineOptions resolvedEngineOptions = SSLHelper.resolveEngineOptions(this.sslEngineOptions, this.useAlpn);
                    supplier = resolvedEngineOptions::sslContextFactory;
                    useWorkerPool = resolvedEngineOptions.getUseWorkerThread();
                }
                catch (Exception e) {
                    p.fail(e);
                    return;
                }
                p.complete(new EngineConfig(sslOptions, supplier, useWorkerPool));
            })).onComplete(promise);
        } else {
            sslContextFactorySupplier = Future.succeededFuture(new EngineConfig(sslOptions, () -> new DefaultSslContextFactory(SslProvider.JDK, false), false));
        }
        return sslContextFactorySupplier;
    }

    static {
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUIRED, org.apache.kyuubi.shade.io.netty.handler.ssl.ClientAuth.REQUIRE);
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUEST, org.apache.kyuubi.shade.io.netty.handler.ssl.ClientAuth.OPTIONAL);
        CLIENT_AUTH_MAPPING.put(ClientAuth.NONE, org.apache.kyuubi.shade.io.netty.handler.ssl.ClientAuth.NONE);
    }

    private class EngineConfig {
        private final SSLOptions sslOptions;
        private final Supplier<SslContextFactory> supplier;
        private final boolean useWorkerPool;

        public EngineConfig(SSLOptions sslOptions, Supplier<SslContextFactory> supplier, boolean useWorkerPool) {
            this.sslOptions = sslOptions;
            this.supplier = supplier;
            this.useWorkerPool = useWorkerPool;
        }

        SslContextProvider sslContextProvider() {
            return new SslContextProvider(SSLHelper.this.clientAuth, SSLHelper.this.endpointIdentificationAlgorithm, SSLHelper.this.applicationProtocols, this.sslOptions.getEnabledCipherSuites(), this.sslOptions.getEnabledSecureTransportProtocols(), SSLHelper.this.keyManagerFactory, SSLHelper.this.keyManagerFactoryMapper, SSLHelper.this.trustManagerFactory, SSLHelper.this.trustManagerMapper, SSLHelper.this.crls, this.supplier);
        }
    }

    private static class CachedProvider {
        final SSLOptions options;
        final long id;
        final SslChannelProvider sslChannelProvider;
        final Throwable failure;

        CachedProvider(SSLOptions options, long id, SslChannelProvider sslChannelProvider, Throwable failure) {
            this.options = options;
            this.id = id;
            this.sslChannelProvider = sslChannelProvider;
            this.failure = failure;
        }
    }
}

