/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.MySQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.PostgreSQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.SQLiteDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\rc\u0001\u0002\u001d:\u0001\u0019C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019y\u0007\u0001)A\u0005K\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bbBA\u0002\u0001\u0001\u0006IA\u001d\u0005\u000b\u0003\u000b\u0001\u0001R1A\u0005\n\u0005\u001d\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011\u001d\t\t\u0002\u0001Q\u0001\nYD\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005u\u0001\u0001)A\u0005\u0003/A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005m\u0002\u0001)A\u0005\u0003_A\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u0003B!\"a\u0016\u0001\u0005\u0004%\u0019aPA-\u0011!\t\t\u0007\u0001Q\u0001\n\u0005m\u0003\"CA=\u0001\t\u0007I\u0011BA>\u0011!\t\t\n\u0001Q\u0001\n\u0005u\u0004\"CAJ\u0001\t\u0007I\u0011BA\b\u0011\u001d\t)\n\u0001Q\u0001\nYDq!a&\u0001\t\u0013\tI\n\u0003\u0005\u0002\"\u0002!\t!OAR\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002x\u0002!\t%!'\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u000b\u0001\u0011\u0005#q\u0003\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqAa\u0011\u0001\t\u0003\u0012)\u0005C\u0004\u0003J\u0001!IAa\u0013\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!q\u000e\u0001\u0005B\tE\u0004b\u0002B;\u0001\u0011\u0005#q\u000f\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u00119\n\u0001C\u0005\u00053CqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003X\u0002!IA!7\t\u000f\t5\b\u0001\"\u0003\u0003p\"9!Q \u0001\u0005\n\t}\bbBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0007'\u0001A\u0011BB\u000b\u000f\u001d\u0019I\"\u000fE\u0001\u000771a\u0001O\u001d\t\u0002\ru\u0001B\u000201\t\u0003\u0019)\u0003C\u0005\u0004(A\u0012\r\u0011\"\u0003\u0004*!A1\u0011\b\u0019!\u0002\u0013\u0019Y\u0003C\u0005\u0004<A\u0012\r\u0011\"\u0003\u0002\b!A1Q\b\u0019!\u0002\u0013\tI\u0001C\u0005\u0004@A\u0012\r\u0011\"\u0003\u0002\u0010!91\u0011\t\u0019!\u0002\u00131(!\u0005&E\u0005\u000ekU\r^1eCR\f7\u000b^8sK*\u0011!hO\u0001\u0005U\u0012\u00147M\u0003\u0002={\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002?\u007f\u000511/\u001a:wKJT!\u0001Q!\u0002\r-LX/\u001e2j\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001M!\u0001aR(T!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u00142kK\u000e$\bC\u0001)R\u001b\u0005Y\u0014B\u0001*<\u00055iU\r^1eCR\f7\u000b^8sKB\u0011A+V\u0007\u0002\u007f%\u0011ak\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005ecV\"\u0001.\u000b\u0005m{\u0014AB2p]\u001aLw-\u0003\u0002^5\nQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t\u0001'\r\u0005\u0002b\u00015\t\u0011\bC\u0003X\u0005\u0001\u0007\u0001,\u0001\u0004eERK\b/Z\u000b\u0002KB\u0011a-\u001b\b\u0003C\u001eL!\u0001[\u001d\u0002\u0019\u0011\u000bG/\u00192bg\u0016$\u0016\u0010]3\n\u0005)\\'!\u0002,bYV,\u0017B\u00017n\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u00039\fQa]2bY\u0006\fq\u0001\u001a2UsB,\u0007%\u0001\bee&4XM]\"mCN\u001cx\n\u001d;\u0016\u0003I\u00042a\u001d;w\u001b\u0005i\u0017BA;n\u0005\u0019y\u0005\u000f^5p]B\u0011qO \b\u0003qr\u0004\"!_7\u000e\u0003iT!a_#\u0002\rq\u0012xn\u001c;?\u0013\tiX.\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~[\u0006yAM]5wKJ\u001cE.Y:t\u001fB$\b%\u0001\tnsN\fH\u000e\u0012:jm\u0016\u00148\t\\1tgV\u0011\u0011\u0011\u0002\t\u0004\u0011\u0006-\u0011BA@J\u0003-!'/\u001b<fe\u000ec\u0017m]:\u0016\u0003Y\fA\u0002\u001a:jm\u0016\u00148\t\\1tg\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u0002\u0018A\u0019\u0011-!\u0007\n\u0007\u0005m\u0011H\u0001\fHK:,'/[2ECR\f'-Y:f\t&\fG.Z2u\u0003!!\u0017.\u00197fGR\u0004\u0013a\u00049sS>\u0014\u0018\u000e^=F]\u0006\u0014G.\u001a3\u0016\u0005\u0005\r\u0002cA:\u0002&%\u0019\u0011qE7\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0002O]5pe&$\u00180\u00128bE2,G\rI\u0001\u0015I\u0006$\u0018m]8ve\u000e,\u0007K]8qKJ$\u0018.Z:\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U2*\u0001\u0003vi&d\u0017\u0002BA\u001d\u0003g\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U!\u0017\r^1t_V\u00148-\u001a)s_B,'\u000f^5fg\u0002\nA\u0002[5lCJL7i\u001c8gS\u001e,\"!!\u0011\u0011\t\u0005\r\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u00051\u0001.[6be&TA!a\u0013\u0002N\u00051!0\u0019=yKJT!!a\u0014\u0002\u0007\r|W.\u0003\u0003\u0002T\u0005\u0015#\u0001\u0004%jW\u0006\u0014\u0018nQ8oM&<\u0017!\u00045jW\u0006\u0014\u0018nQ8oM&<\u0007%\u0001\tiS.\f'/\u001b#bi\u0006\u001cv.\u001e:dKV\u0011\u00111\f\t\u0005\u0003\u0007\ni&\u0003\u0003\u0002`\u0005\u0015#\u0001\u0005%jW\u0006\u0014\u0018\u000eR1uCN{WO]2f\u0003EA\u0017n[1sS\u0012\u000bG/Y*pkJ\u001cW\r\t\u0015\u0004'\u0005\u0015\u0004\u0003BA4\u0003kj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002p\u0005E\u0014AB2p[6|gN\u0003\u0003\u0002t\u00055\u0013AB4p_\u001edW-\u0003\u0003\u0002x\u0005%$!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u00061Q.\u00199qKJ,\"!! \u0011\t\u0005}\u0014QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006AA-\u0019;bE&tGM\u0003\u0003\u0002\b\u0006%\u0015a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003\u0017\u000bi%A\u0005gCN$XM\u001d=nY&!\u0011qRAA\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\na\u0002^3s[&t\u0017\r\\*uCR,7/A\buKJl\u0017N\\1m'R\fG/Z:!\u0003)Ig.\u001b;TG\",W.\u0019\u000b\u0003\u00037\u00032a]AO\u0013\r\ty*\u001c\u0002\u0005+:LG/A\u0007hKRLe.\u001b;TG\",W.\u0019\u000b\u0004e\u0006\u0015\u0006BB2\u001a\u0001\u0004\t9\u000b\u0005\u0003\u0002*\u0006\rgbAAVO:!\u0011QVAa\u001d\u0011\ty+a0\u000f\t\u0005E\u0016Q\u0018\b\u0005\u0003g\u000bYL\u0004\u0003\u00026\u0006efbA=\u00028&\tA)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J!\u0001P\u001f\n\u0005iZ\u0014\u0002BAc\u0003\u000f\u0014A\u0002R1uC\n\f7/\u001a+za\u0016T!\u0001[\u001d\u0002!\u001d,GoU2iK6\fg+\u001a:tS>tG\u0003BAg\u00033\u0004\u0012b]Ah\u0003'\f\u0019.a5\n\u0007\u0005EWN\u0001\u0004UkBdWm\r\t\u0004g\u0006U\u0017bAAl[\n\u0019\u0011J\u001c;\t\r\u0005m'\u00041\u0001w\u0003%\u00198\r[3nCV\u0013H.\u0001\nhKRd\u0015\r^3tiN\u001b\u0007.Z7b+JdGc\u0001:\u0002b\"9\u00111]\u000eA\u0002\u0005\u0015\u0018AC:dQ\u0016l\u0017-\u0016:mgB)\u0011q]Aym:!\u0011\u0011^Aw\u001d\rI\u00181^\u0005\u0002]&\u0019\u0011q^7\u0002\u000fA\f7m[1hK&!\u00111_A{\u0005\r\u0019V-\u001d\u0006\u0004\u0003_l\u0017!B2m_N,\u0017AD5og\u0016\u0014H/T3uC\u0012\fG/\u0019\u000b\u0005\u00037\u000bi\u0010\u0003\u0004=;\u0001\u0007\u0011q \t\u0005\u0005\u0003\u00119!\u0004\u0002\u0003\u0004)\u0019!QA\u001e\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\n\t\r!\u0001C'fi\u0006$\u0017\r^1\u0002\u0019AL7m['fi\u0006$\u0017\r^1\u0015\t\t=!\u0011\u0003\t\u0005gR\fy\u0010\u0003\u0004\u0003\u0014y\u0001\rA^\u0001\u000fWf,XOY5J]N$\u0018M\\2f\u0003Y!(/\u00198tM>\u0014X.T3uC\u0012\fG/Y*uCR,G\u0003CA\u0012\u00053\u0011iB!\t\t\r\tmq\u00041\u0001w\u0003)IG-\u001a8uS\u001aLWM\u001d\u0005\u0007\u0005?y\u0002\u0019\u0001<\u0002\u0013\u0019\u0014x.\\*uCR,\u0007B\u0002B\u0012?\u0001\u0007a/A\u0006uCJ<W\r^*uCR,\u0017aC4fi6+G/\u00193bi\u0006$B!a@\u0003*!1!1\u0004\u0011A\u0002Y\fqbZ3u\u001b\u0016$\u0018\rZ1uC2K7\u000f\u001e\u000b\t\u0005_\u0011\tDa\u000f\u0003@A1\u0011q]Ay\u0003\u007fDqAa\r\"\u0001\u0004\u0011)$\u0001\u0004gS2$XM\u001d\t\u0005\u0005\u0003\u00119$\u0003\u0003\u0003:\t\r!AD'fi\u0006$\u0017\r^1GS2$XM\u001d\u0005\b\u0005{\t\u0003\u0019AAj\u0003\u00111'o\\7\t\u000f\t\u0005\u0013\u00051\u0001\u0002T\u0006!1/\u001b>f\u00035\u0019w.\u001e8u\u001b\u0016$\u0018\rZ1uCR!\u00111\u001bB$\u0011\u001d\u0011\u0019D\ta\u0001\u0005k\t1#Y:tK6\u0014G.Z,iKJ,7\t\\1vg\u0016$RA\u001eB'\u0005\u001fBqAa\r$\u0001\u0004\u0011)\u0004C\u0004\u0003R\r\u0002\rAa\u0015\u0002\rA\f'/Y7t!\u0019\u0011)Fa\u0018\u0003d5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&A\u0004nkR\f'\r\\3\u000b\u0007\tuS.\u0001\u0006d_2dWm\u0019;j_:LAA!\u0019\u0003X\tQA*[:u\u0005V4g-\u001a:\u0011\u0007M\u0014)'C\u0002\u0003h5\u00141!\u00118z\u00039)\b\u000fZ1uK6+G/\u00193bi\u0006$B!a'\u0003n!1A\b\na\u0001\u0003\u007f\f1d\u00197fC:,\b/T3uC\u0012\fG/\u0019\"z\u0013\u0012,g\u000e^5gS\u0016\u0014H\u0003BAN\u0005gBaAa\u0007&\u0001\u00041\u0018\u0001F2mK\u0006tW\u000f]'fi\u0006$\u0017\r^1Cs\u0006;W\r\u0006\u0003\u0002\u001c\ne\u0004b\u0002B>M\u0001\u0007!QP\u0001\u0007[\u0006D\u0018iZ3\u0011\u0007M\u0014y(C\u0002\u0003\u00026\u0014A\u0001T8oO\u0006i!-^5mI6+G/\u00193bi\u0006$BAa\f\u0003\b\"9!\u0011R\u0014A\u0002\t-\u0015!\u0003:fgVdGoU3u!\u0011\u0011iIa%\u000e\u0005\t=%b\u0001BI\u0017\u0006\u00191/\u001d7\n\t\tU%q\u0012\u0002\n%\u0016\u001cX\u000f\u001c;TKR\fq!\u001a=fGV$X\r\u0006\u0005\u0002\u001c\nm%Q\u0015BT\u0011\u001d\u0011i\n\u000ba\u0001\u0005?\u000bAaY8o]B!!Q\u0012BQ\u0013\u0011\u0011\u0019Ka$\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0004\u0003\u0012\"\u0002\rA\u001e\u0005\b\u0005#B\u0003\u0019\u0001BU!\u0015\u0019(1\u0016B2\u0013\r\u0011i+\u001c\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!D<ji\"\u0014Vm];miN+G/\u0006\u0003\u00034\nmF\u0003\u0003B[\u0005#\u0014\u0019N!6\u0015\t\t]&q\u0019\t\u0005\u0005s\u0013Y\f\u0004\u0001\u0005\u000f\tu\u0016F1\u0001\u0003@\n\tA+\u0005\u0003\u0003B\n\r\u0004cA:\u0003D&\u0019!QY7\u0003\u000f9{G\u000f[5oO\"9!\u0011Z\u0015A\u0002\t-\u0017!\u00014\u0011\u000fM\u0014iMa#\u00038&\u0019!qZ7\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002BOS\u0001\u0007!q\u0014\u0005\u0007\u0005#K\u0003\u0019\u0001<\t\u000f\tE\u0013\u00061\u0001\u0003*\u0006yq/\u001b;i+B$\u0017\r^3D_VtG/\u0006\u0003\u0003\\\n\u0005H\u0003\u0003Bo\u0005O\u0014IOa;\u0015\t\t}'1\u001d\t\u0005\u0005s\u0013\t\u000fB\u0004\u0003>*\u0012\rAa0\t\u000f\t%'\u00061\u0001\u0003fB91O!4\u0002T\n}\u0007b\u0002BOU\u0001\u0007!q\u0014\u0005\u0007\u0005#S\u0003\u0019\u0001<\t\u000f\tE#\u00061\u0001\u0003*\u0006\u00112/\u001a;Ti\u0006$X-\\3oiB\u000b'/Y7t)\u0019\tYJ!=\u0003|\"9!1_\u0016A\u0002\tU\u0018!C:uCR,W.\u001a8u!\u0011\u0011iIa>\n\t\te(q\u0012\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bb\u0002B)W\u0001\u0007!\u0011V\u0001\u000em\u0006dW/Z!t'R\u0014\u0018N\\4\u0015\u0007Y\u001c\t\u0001C\u0004\u0004\u00041\u0002\rAa\u0019\u0002\u0007=\u0014'.\u0001\u0006tiJLgn\u001a\u001aNCB$Ba!\u0003\u0004\u0010A)qoa\u0003wm&!1QBA\u0001\u0005\ri\u0015\r\u001d\u0005\u0007\u0007#i\u0003\u0019\u0001<\u0002\u0007M$(/\u0001\u0006tiJLgn\u001a\u001aTKF$B!!:\u0004\u0018!11\u0011\u0003\u0018A\u0002Y\f\u0011C\u0013#C\u00076+G/\u00193bi\u0006\u001cFo\u001c:f!\t\t\u0007gE\u00021\u0007?\u00012a]B\u0011\u0013\r\u0019\u0019#\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\rm\u0011AE*D\u0011\u0016k\u0015iX+S\u0019~\u0003\u0016\t\u0016+F%:+\"aa\u000b\u0011\t\r52QG\u0007\u0003\u0007_QAa!\r\u00044\u0005AQ.\u0019;dQ&twMC\u0002\u000265LAaa\u000e\u00040\t)!+Z4fq\u0006\u00192k\u0011%F\u001b\u0006{VK\u0015'`!\u0006#F+\u0012*OA\u0005qQ*\u0012+B\t\u0006#\u0016i\u0018+B\u00052+\u0015aD'F)\u0006#\u0015\tV!`)\u0006\u0013E*\u0012\u0011\u0002!5+E+\u0011#B)\u0006{6i\u0014'V\u001b:\u001b\u0016!E'F)\u0006#\u0015\tV!`\u0007>cU+\u0014(TA\u0001")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private String mysqlDriverClass;
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final GenericDatabaseDialect dialect;
    private final boolean priorityEnabled;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String mysqlDriverClass$lzycompute() {
        JDBCMetadataStore jDBCMetadataStore = this;
        synchronized (jDBCMetadataStore) {
            if (!this.bitmap$0) {
                this.mysqlDriverClass = ReflectUtils$.MODULE$.isClassLoadable("com.mysql.cj.jdbc.Driver", ReflectUtils$.MODULE$.isClassLoadable$default$2()) ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
                this.bitmap$0 = true;
            }
        }
        return this.mysqlDriverClass;
    }

    private String mysqlDriverClass() {
        if (!this.bitmap$0) {
            return this.mysqlDriverClass$lzycompute();
        }
        return this.mysqlDriverClass;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private GenericDatabaseDialect dialect() {
        return this.dialect;
    }

    private boolean priorityEnabled() {
        return this.priorityEnabled;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)x$3.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$4, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        });
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(472).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager,\n         |priority\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToInteger((int)metadata.priority())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public synchronized Option<Metadata> pickMetadata(String kyuubiInstance) {
        return JdbcUtils$.MODULE$.executeQueryWithRowMapper(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(101).append("SELECT identifier FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n         |WHERE state=?\n         |ORDER BY ").append((Object)(this.priorityEnabled() ? "priority DESC, " : "")).append("create_time ASC LIMIT 1\n         |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            stmt.setString(1, OperationState$.MODULE$.INITIALIZED().toString());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> resultSet.getString(1), (DataSource)this.hikariDataSource()).headOption().filter((Function1 & Serializable & scala.Serializable)preSelectedBatchId -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$pickMetadata$3(this, kyuubiInstance, preSelectedBatchId))).map((Function1 & Serializable & scala.Serializable)pickedBatchId -> this.getMetadata((String)pickedBatchId));
    }

    @Override
    public boolean transformMetadataState(String identifier, String fromState, String targetState) {
        String query = new java.lang.StringBuilder(56).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" SET state = ? WHERE identifier = ? AND state = ?").toString();
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$transformMetadataState$1(this, query, fromState, identifier, targetState, connection)), (DataSource)this.hikariDataSource()));
    }

    @Override
    public Metadata getMetadata(String identifier) {
        String query = new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append("SELECT ");
        queryBuilder.append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS());
        queryBuilder.append(new java.lang.StringBuilder(6).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        queryBuilder.append(" ORDER BY key_id ");
        queryBuilder.append(this.dialect().limitClause(size, from));
        String query = queryBuilder.toString();
        return (Seq)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params.toSeq(), (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs)), (DataSource)this.hikariDataSource());
    }

    @Override
    public int countMetadata(MetadataFilter filter) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(21).append("SELECT COUNT(1) FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        String query = queryBuilder.toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.executeQueryWithRowMapper(query, (Function1 & Serializable & scala.Serializable)stmt -> {
            this.setStatementParams(stmt, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> BoxesRunTime.boxToInteger((int)resultSet.getInt(1)), (DataSource)this.hikariDataSource()).head());
    }

    private String assembleWhereClause(MetadataFilter filter, ListBuffer<Object> params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 = 1"}));
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)"session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$2(x$7))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)"UPPER(engine_type) = ?");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$4(x$8))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)"user_name = ?");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$6(x$9))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.requestName()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$8(x$10))).foreach((Function1 & Serializable & scala.Serializable)requestName -> {
            whereConditions.$plus$eq((Object)"request_name = ?");
            return params.$plus$eq(requestName);
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$10(x$11))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)"create_time >= ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)"end_time > 0");
            whereConditions.$plus$eq((Object)"end_time <= ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return whereConditions.mkString("WHERE ", " AND ", "");
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.kyuubiInstance()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq((Object)metadata.kyuubiInstance());
        });
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)metadata.state());
        });
        Option$.MODULE$.apply(metadata.requestConf()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.nonEmpty())).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            setClauses.$plus$eq((Object)"request_conf =?");
            return params.$plus$eq((Object)this.valueAsString(metadata.requestConf()));
        });
        metadata.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            setClauses.$plus$eq((Object)"cluster_manager = ?");
            return params.$plus$eq(cm);
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)"end_time = ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)"engine_open_time = ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            setClauses.$plus$eq((Object)"engine_id = ?");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            setClauses.$plus$eq((Object)"engine_name = ?");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            setClauses.$plus$eq((Object)"engine_url = ?");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            setClauses.$plus$eq((Object)"engine_state = ?");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)"engine_error = ?");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", ", ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ?");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params.toSeq(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(52).append("Error updating metadata for ").append(metadata$2.identifier()).append(" by SQL: ").append(query$5).append(", ").append("with params: ").append(params$4.mkString(", ")).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    private Seq<Metadata> buildMetadata(ResultSet resultSet) {
        Seq seq;
        try {
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String resource = resultSet.getString("resource");
                String className = resultSet.getString("class_name");
                String requestName = resultSet.getString("request_name");
                scala.collection.immutable.Map<String, String> requestConf = this.string2Map(resultSet.getString("request_conf"));
                Seq<String> requestArgs = this.string2Seq(resultSet.getString("request_args"));
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                String x$16 = engineId;
                String x$17 = engineName;
                String x$18 = engineUrl;
                String x$19 = engineState;
                Option x$20 = engineError;
                long x$21 = endTime;
                boolean x$22 = peerInstanceClosed;
                long x$23 = Metadata$.MODULE$.apply$default$16();
                int x$24 = Metadata$.MODULE$.apply$default$23();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$23, x$16, x$17, x$18, x$19, (Option<String>)x$20, x$21, x$24, x$22);
                metadataList.$plus$eq((Object)metadata);
            }
            seq = metadataList.toSeq();
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return seq;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("execute sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("executeQuery sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("executeUpdate sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$5(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("Execute init schema ddl successfully.\n                    |").append(ddlStatement).append("\n                    |").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.trim().split(";"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$5($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource());
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ void $anonfun$pickMetadata$4(String kyuubiInstance$1, String preSelectedBatchId$1, PreparedStatement stmt) {
        stmt.setString(1, kyuubiInstance$1);
        stmt.setString(2, OperationState$.MODULE$.PENDING().toString());
        stmt.setString(3, preSelectedBatchId$1);
        stmt.setString(4, OperationState$.MODULE$.INITIALIZED().toString());
    }

    public static final /* synthetic */ boolean $anonfun$pickMetadata$3(JDBCMetadataStore $this, String kyuubiInstance$1, String preSelectedBatchId) {
        return JdbcUtils$.MODULE$.executeUpdate(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(106).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n           |SET kyuubi_instance=?, state=?\n           |WHERE identifier=? AND state=?\n           |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            JDBCMetadataStore.$anonfun$pickMetadata$4(kyuubiInstance$1, preSelectedBatchId, stmt);
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource()) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$transformMetadataState$1(JDBCMetadataStore $this, String query$2, String fromState$1, String identifier$1, String targetState$1, Connection connection) {
        return BoxesRunTime.unboxToBoolean($this.withUpdateCount(connection, query$2, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromState$1, identifier$1, targetState$1}), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)updateCount -> updateCount == 1));
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$8(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$10(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block16: {
            GenericDatabaseDialect genericDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.sqlite.JDBC");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.mysqlDriverClass());
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.postgresql.Driver");
                    } else {
                        Enumeration.Value value8 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new IllegalArgumentException("No jdbc driver defined");
                            });
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value10 = this.dbType();
            Enumeration.Value value11 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                genericDatabaseDialect = new SQLiteDatabaseDialect();
            } else {
                Enumeration.Value value13 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    genericDatabaseDialect = new MySQLDatabaseDialect();
                } else {
                    Enumeration.Value value15 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        genericDatabaseDialect = new PostgreSQLDatabaseDialect();
                    } else {
                        Enumeration.Value value17 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            genericDatabaseDialect = new GenericDatabaseDialect();
                        } else {
                            throw new MatchError((Object)value10);
                        }
                    }
                }
            }
            this.dialect = genericDatabaseDialect;
            this.priorityEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PRIORITY_ENABLED()));
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl(JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJdbcUrl(conf));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block16;
            this.initSchema();
        }
    }
}

