/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ExecPoolStatistic;
import org.apache.kyuubi.client.api.v1.dto.GetColumnsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetCrossReferenceRequest;
import org.apache.kyuubi.client.api.v1.dto.GetFunctionsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetPrimaryKeysRequest;
import org.apache.kyuubi.client.api.v1.dto.GetSchemasRequest;
import org.apache.kyuubi.client.api.v1.dto.GetTablesRequest;
import org.apache.kyuubi.client.api.v1.dto.InfoDetail;
import org.apache.kyuubi.client.api.v1.dto.KyuubiSessionEvent;
import org.apache.kyuubi.client.api.v1.dto.OperationData;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.client.api.v1.dto.SessionHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenCount;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenRequest;
import org.apache.kyuubi.client.api.v1.dto.StatementRequest;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.ApiUtils$;
import org.apache.kyuubi.server.api.v1.SessionsResource$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rMh!B\u000e\u001d\u0001qA\u0003\"B\u001c\u0001\t\u0003I\u0004\"\u0002\u001f\u0001\t\u0007i\u0004\"B)\u0001\t\u0013\u0011\u0006\"\u0002,\u0001\t\u00039\u0006bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002v\u0002!\t!a>\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B9\u0001\u0011\u0005!1\u000f\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005GCqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003b\u0002!\tAa9\t\u000f\te\b\u0001\"\u0001\u0003|\"91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u001d\u0001\u0011\u000511\b\u0005\b\u00073\u0002A\u0011AB.\u0011\u001d\u0019I\b\u0001C\u0001\u0007w:qa!3\u001d\u0011\u0003\u0019YM\u0002\u0004\u001c9!\u00051Q\u001a\u0005\u0007o]!\taa4\t\u0013\rEwC1A\u0005\u0006\rM\u0007\u0002CBy/\u0001\u0006ia!6\u0003!M+7o]5p]N\u0014Vm]8ve\u000e,'BA\u000f\u001f\u0003\t1\u0018G\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0005\u0005\u0012\u0013AB:feZ,'O\u0003\u0002$I\u000511._;vE&T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sON!\u0001!K\u00184!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001'M\u0007\u0002=%\u0011!G\b\u0002\u0012\u0003BL'+Z9vKN$8i\u001c8uKb$\bC\u0001\u001b6\u001b\u0005\u0011\u0013B\u0001\u001c#\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002uA\u00111\bA\u0007\u00029\u0005yAo\\*fgNLwN\u001c%b]\u0012dW\r\u0006\u0002?\tB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011II\u0001\bg\u0016\u001c8/[8o\u0013\t\u0019\u0005IA\u0007TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0005\u0006\u000b\n\u0001\rAR\u0001\u0004gR\u0014\bCA$O\u001d\tAE\n\u0005\u0002JW5\t!J\u0003\u0002Lq\u00051AH]8pizJ!!T\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001b.\nab]3tg&|g.T1oC\u001e,'/F\u0001T!\tyD+\u0003\u0002V\u0001\nq1+Z:tS>tW*\u00198bO\u0016\u0014\u0018\u0001C:fgNLwN\\:\u0015\u0003a\u00032!\u00170b\u001d\tQFL\u0004\u0002J7&\tA&\u0003\u0002^W\u00059\u0001/Y2lC\u001e,\u0017BA0a\u0005\r\u0019V-\u001d\u0006\u0003;.\u0002\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0007\u0011$xN\u0003\u0002\u001eM*\u0011qd\u001a\u0006\u0003Q\n\naa\u00197jK:$\u0018B\u00016d\u0005-\u0019Vm]:j_:$\u0015\r^1)\u0005\u0011a\u0007CA7u\u001b\u0005q'BA8q\u0003\t\u00118O\u0003\u0002re\u0006\u0011qo\u001d\u0006\u0002g\u0006)!.\u0019<bq&\u0011QO\u001c\u0002\u0004\u000f\u0016#\u0006F\u0004\u0003x\u0003\u001f\t\t\"!\u0006\u0002\u0018\u0005\u0015\u0013q\t\t\u0004q\u0006-Q\"A=\u000b\u0005i\\\u0018!\u0003:fgB|gn]3t\u0015\taX0A\u0006b]:|G/\u0019;j_:\u001c(B\u0001@\u0000\u0003\ry\u0017m\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0002wg)!\u0011QAA\u0004\u0003\u001d\u0019x/Y4hKJT!!!\u0003\u0002\u0005%|\u0017bAA\u0007s\nY\u0011\t]5SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,7i\u001c3fC\t\t\u0019\"A\u00023aA\nqaY8oi\u0016tG\u000f\f\u0002\u0002\u001a-R\u00111DA\u0014\u0003S\ti#a\f\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t|\u0003\u0015iW\rZ5b\u0013\u0011\t)#a\b\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0011\u0003\u0003W\t\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8\u0002\u000b\u0005\u0014(/Y=,\r\u0005E\u0012qGA\u001d!\u0011\ti\"a\r\n\t\u0005U\u0012q\u0004\u0002\f\u0003J\u0014\u0018-_*dQ\u0016l\u0017-\u0001\u0004tG\",W.Y\u0016\u0007\u0003w\t\t%a\u0011\u0011\t\u0005u\u0011QH\u0005\u0005\u0003\u007f\tyB\u0001\u0004TG\",W.Y\u0001\u000fS6\u0004H.Z7f]R\fG/[8oG\u0005\t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!!\u0013\u0002C\u001d,G\u000f\t;iK\u0002b\u0017n\u001d;!_\u001a\u0004\u0013\r\u001c7!Y&4X\rI:fgNLwN\\:\u0002\u0017M,7o]5p]&sgm\u001c\u000b\u0005\u0003\u001f\n)\u0006E\u0002c\u0003#J1!a\u0015d\u0005IY\u00150^;cSN+7o]5p]\u00163XM\u001c;\t\r\u0005]S\u00011\u0001G\u0003A\u0019Xm]:j_:D\u0015M\u001c3mKN#(\u000f\u000b\u0005\u0002V\u0005m\u0013\u0011MA2!\ri\u0017QL\u0005\u0004\u0003?r'!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\t\t)'A\u0007tKN\u001c\u0018n\u001c8IC:$G.\u001a\u0015\b\u000b\u0005%\u0014\u0011MA8!\ri\u00171N\u0005\u0004\u0003[r'\u0001\u0002)bi\"\f#!!\u001d\u0002\u001fm\u001cXm]:j_:D\u0015M\u001c3mKvD#!\u00027)\u001d\u00159\u0018qBA\t\u0003+\t9(!\u0012\u0002\u00001\u0012\u0011\u0011P\u0016\u000b\u00037\t9#!\u000b\u00028\u0005m4FBA\u001e\u0003\u0003\nih\t\u0002\u0002P\u0005\u0012\u0011\u0011Q\u00012O\u0016$\b%\u0019\u0011tKN\u001c\u0018n\u001c8!KZ,g\u000e\u001e\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3s\u0003\u001d9W\r^%oM>$b!a\"\u0002\u000e\u0006E\u0005c\u00012\u0002\n&\u0019\u00111R2\u0003\u0015%sgm\u001c#fi\u0006LG\u000e\u0003\u0004\u0002X\u0019\u0001\rA\u0012\u0015\t\u0003\u001b\u000bY&!\u0019\u0002d!9\u00111\u0013\u0004A\u0002\u0005U\u0015\u0001C5oM>$\u0016\u0010]3\u0011\u0007)\n9*C\u0002\u0002\u001a.\u00121!\u00138uQ!\t\t*a\u0017\u0002b\u0005u\u0015EAAJQ\u001d1\u0011\u0011NA1\u0003C\u000b#!a)\u0002?m\u001cXm]:j_:D\u0015M\u001c3mKv|\u0013N\u001c4p_mLgNZ8UsB,W\u0010\u000b\u0002\u0007Y\"raa^A\b\u0003#\t)\"!+\u0002F\u0005EFFAAVW)\tY\"a\n\u0002*\u0005]\u0012QV\u0016\u0007\u0003w\t\t%a,$\u0005\u0005\u001d\u0015EAAZ\u0003Y;W\r\u001e\u0011bA%tgm\u001c:nCRLwN\u001c\u0011eKR\f\u0017\u000e\u001c\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3sA\u0005tG\rI1!gB,7-\u001b4jG\u0002JgNZ8s[\u0006$\u0018n\u001c8!if\u0004X-\u0001\u0007tKN\u001c\u0018n\u001c8D_VtG\u000f\u0006\u0002\u0002:B\u0019!-a/\n\u0007\u0005u6M\u0001\tTKN\u001c\u0018n\u001c8Pa\u0016t7i\\;oi\":q!!\u001b\u0002b\u0005\u0005\u0017EAAb\u0003\u0015\u0019w.\u001e8uQ\t9A\u000e\u000b\b\bo\u0006=\u0011\u0011CA\u000b\u0003\u0013\f)%!5-\u0005\u0005-7FCA\u000e\u0003O\tI#a\u000e\u0002N.2\u00111HA!\u0003\u001f\u001c#!!/\"\u0005\u0005M\u0017AI$fi\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!_B,g\u000eI:fgNLwN\u001c\u0011d_VtG/A\tfq\u0016\u001c\u0007k\\8m'R\fG/[:uS\u000e$\"!!7\u0011\u0007\t\fY.C\u0002\u0002^\u000e\u0014\u0011#\u0012=fGB{w\u000e\\*uCRL7\u000f^5dQ\u001dA\u0011\u0011NA1\u0003C\f#!a9\u0002%\u0015DXm\u0019)p_2|3\u000f^1uSN$\u0018n\u0019\u0015\u0003\u00111Dc\u0002C<\u0002\u0010\u0005E\u0011QCAu\u0003\u000b\n\t\u0010\f\u0002\u0002l.R\u00111DA\u0014\u0003S\t9$!<,\r\u0005m\u0012\u0011IAxG\t\tI.\t\u0002\u0002t\u0006Qs)\u001a;!gR\fG/[:uS\u000e\u0004\u0013N\u001c4pA=4\u0007EY1dW\u001e\u0014x.\u001e8eA\u0015DXmY;u_J\u001c\u0018aC8qK:\u001cVm]:j_:$B!!?\u0002~B\u0019!-a?\n\u0005\r\u001b\u0007bBA\u0000\u0013\u0001\u0007!\u0011A\u0001\be\u0016\fX/Z:u!\r\u0011'1A\u0005\u0004\u0005\u000b\u0019'AE*fgNLwN\\(qK:\u0014V-];fgRD3!\u0003B\u0005!\ri'1B\u0005\u0004\u0005\u001bq'\u0001\u0002)P'RCc\"C<\u0002\u0010\u0005E\u0011Q\u0003B\t\u0003\u000b\u0012)\u0002\f\u0002\u0003\u0014-2\u00111DA\u0014\u0003S\t#Aa\u0006\u0002-=\u0003XM\u001c\u0015de\u0016\fG/Z\u0015!C\u0002\u001aXm]:j_:\fAb\u00197pg\u0016\u001cVm]:j_:$BA!\b\u0003*A!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$9\fAaY8sK&!!q\u0005B\u0011\u0005!\u0011Vm\u001d9p]N,\u0007BBA,\u0015\u0001\u0007a\t\u000b\u0005\u0003*\u0005m\u0013\u0011MA2Q\u001dQ\u0011\u0011NA1\u0003_B3A\u0003B\u0019!\ri'1G\u0005\u0004\u0005kq'A\u0002#F\u0019\u0016#V\t\u000b\b\u000bo\u0006=\u0011\u0011CA\u000b\u0005s\t)Ea\u000f-\u0005\tM\u0011E\u0001B\u001f\u0003=\u0019En\\:fA\u0005\u00043/Z:tS>t\u0017\u0001E3yK\u000e,H/Z*uCR,W.\u001a8u)\u0019\u0011\u0019Ea\u0014\u0003TA!!Q\tB&\u001b\t\u00119EC\u0002\u0003J\t\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\t5#q\t\u0002\u0010\u001fB,'/\u0019;j_:D\u0015M\u001c3mK\"1\u0011qK\u0006A\u0002\u0019C\u0003Ba\u0014\u0002\\\u0005\u0005\u00141\r\u0005\b\u0003\u007f\\\u0001\u0019\u0001B+!\r\u0011'qK\u0005\u0004\u00053\u001a'\u0001E*uCR,W.\u001a8u%\u0016\fX/Z:uQ\u001dY\u0011\u0011NA1\u0005;\n#Aa\u0018\u0002Im\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0gR\fG/Z7f]RD3a\u0003B\u0005Q9Yq/a\u0004\u0002\u0012\u0005U!QMA#\u0005[b#Aa\u001a,\u0015\u0005m\u0011qEA\u0015\u0003o\u0011Ig\u000b\u0004\u0002<\u0005\u0005#1N\u0012\u0003\u0005\u0007\n#Aa\u001c\u0002_\r\u0013X-\u0019;fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8!o&$\b\u000eI#Y\u000b\u000e+F+R0T)\u0006#V)T#O)\u0002\"\u0018\u0010]3\u0002\u0017\u001d,G\u000fV=qK&sgm\u001c\u000b\u0005\u0005\u0007\u0012)\b\u0003\u0004\u0002X1\u0001\rA\u0012\u0015\t\u0005k\nY&!\u0019\u0002d!:A\"!\u001b\u0002b\tm\u0014E\u0001B?\u0003\rZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_QL\b/Z%oM>D3\u0001\u0004B\u0005Q9aq/a\u0004\u0002\u0012\u0005U!1QA#\u0005\u000bc#Aa\u001a\"\u0005\t\u001d\u0015aK\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U3B+u,\u0013(G\u001f\u0002\"\u0018\u0010]3\u0002\u0017\u001d,GoQ1uC2|wm\u001d\u000b\u0005\u0005\u0007\u0012i\t\u0003\u0004\u0002X5\u0001\rA\u0012\u0015\t\u0005\u001b\u000bY&!\u0019\u0002d!:Q\"!\u001b\u0002b\tM\u0015E\u0001BK\u0003\rZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\r\fG/\u00197pOND3!\u0004B\u0005Q9iq/a\u0004\u0002\u0012\u0005U!1TA#\u0005;c#Aa\u001a\"\u0005\t}\u0015AK\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0D\u0003R\u000bEjT$TAQL\b/Z\u0001\u000bO\u0016$8k\u00195f[\u0006\u001cHC\u0002B\"\u0005K\u0013I\u000b\u0003\u0004\u0002X9\u0001\rA\u0012\u0015\t\u0005K\u000bY&!\u0019\u0002d!9\u0011q \bA\u0002\t-\u0006c\u00012\u0003.&\u0019!qV2\u0003#\u001d+GoU2iK6\f7OU3rk\u0016\u001cH\u000fK\u0004\u000f\u0003S\n\tGa-\"\u0005\tU\u0016AI>tKN\u001c\u0018n\u001c8IC:$G.Z?0_B,'/\u0019;j_:\u001cxf]2iK6\f7\u000fK\u0002\u000f\u0005\u0013AcBD<\u0002\u0010\u0005E\u0011Q\u0003B^\u0003\u000b\u0012i\f\f\u0002\u0003h\u0005\u0012!qX\u0001*\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?N\u001b\u0005*R'B'\u0002\"\u0018\u0010]3\u0002\u0013\u001d,G\u000fV1cY\u0016\u001cHC\u0002B\"\u0005\u000b\u0014I\r\u0003\u0004\u0002X=\u0001\rA\u0012\u0015\t\u0005\u000b\fY&!\u0019\u0002d!9\u0011q`\bA\u0002\t-\u0007c\u00012\u0003N&\u0019!qZ2\u0003!\u001d+G\u000fV1cY\u0016\u001c(+Z9vKN$\bfB\b\u0002j\u0005\u0005$1[\u0011\u0003\u0005+\f\u0011e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|C/\u00192mKND3a\u0004B\u0005Q9yq/a\u0004\u0002\u0012\u0005U!1\\A#\u0005;d#Aa\u001a\"\u0005\t}\u0017\u0001K\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U\u0003\ncUi\u0015\u0011usB,\u0017!D4fiR\u000b'\r\\3UsB,7\u000f\u0006\u0003\u0003D\t\u0015\bBBA,!\u0001\u0007a\t\u000b\u0005\u0003f\u0006m\u0013\u0011MA2Q\u001d\u0001\u0012\u0011NA1\u0005W\f#A!<\u0002Km\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0i\u0006\u0014G.\u001a+za\u0016\u001c\bf\u0001\t\u0003\n!r\u0001c^A\b\u0003#\t)Ba=\u0002F\tUHF\u0001B4C\t\u001190A\u0017De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`)\u0006\u0013E*R0U3B+5\u000b\t;za\u0016\f!bZ3u\u0007>dW/\u001c8t)\u0019\u0011\u0019E!@\u0004\u0002!1\u0011qK\tA\u0002\u0019C\u0003B!@\u0002\\\u0005\u0005\u00141\r\u0005\b\u0003\u007f\f\u0002\u0019AB\u0002!\r\u00117QA\u0005\u0004\u0007\u000f\u0019'!E$fi\u000e{G.^7ogJ+\u0017/^3ti\":\u0011#!\u001b\u0002b\r-\u0011EAB\u0007\u0003\tZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\r|G.^7og\"\u001a\u0011C!\u0003)\u001dE9\u0018qBA\t\u0003+\u0019\u0019\"!\u0012\u0004\u00161\u0012!qM\u0011\u0003\u0007/\t\u0011f\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+EkX\"P\u0019Vkej\u0015\u0011usB,\u0017\u0001D4fi\u001a+hn\u0019;j_:\u001cHC\u0002B\"\u0007;\u0019\t\u0003\u0003\u0004\u0002XI\u0001\rA\u0012\u0015\t\u0007;\tY&!\u0019\u0002d!9\u0011q \nA\u0002\r\r\u0002c\u00012\u0004&%\u00191qE2\u0003'\u001d+GOR;oGRLwN\\:SKF,Xm\u001d;)\u000fI\tI'!\u0019\u0004,\u0005\u00121QF\u0001%wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018gk:\u001cG/[8og\"\u001a!C!\u0003)\u001dI9\u0018qBA\t\u0003+\u0019\u0019$!\u0012\u000461\u0012!qM\u0011\u0003\u0007o\t1f\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+Ek\u0018$V\u001d\u000e#\u0016j\u0014(TAQL\b/Z\u0001\u000fO\u0016$\bK]5nCJL8*Z=t)\u0019\u0011\u0019e!\u0010\u0004B!1\u0011qK\nA\u0002\u0019C\u0003b!\u0010\u0002\\\u0005\u0005\u00141\r\u0005\b\u0003\u007f\u001c\u0002\u0019AB\"!\r\u00117QI\u0005\u0004\u0007\u000f\u001a'!F$fiB\u0013\u0018.\\1ss.+\u0017p\u001d*fcV,7\u000f\u001e\u0015\b'\u0005%\u0014\u0011MB&C\t\u0019i%\u0001\u0014|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7o\f9sS6\f'/_&fsND3a\u0005B\u0005Q9\u0019r/a\u0004\u0002\u0012\u0005U11KA#\u0007+b#Aa\u001a\"\u0005\r]\u0013!L\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0Q%&k\u0015IU-`\u0017\u0016K\u0006\u0005^=qK\u0006\tr-\u001a;De>\u001c8OU3gKJ,gnY3\u0015\r\t\r3QLB1\u0011\u0019\t9\u0006\u0006a\u0001\r\"B1QLA.\u0003C\n\u0019\u0007C\u0004\u0002\u0000R\u0001\raa\u0019\u0011\u0007\t\u001c)'C\u0002\u0004h\r\u0014\u0001dR3u\u0007J|7o\u001d*fM\u0016\u0014XM\\2f%\u0016\fX/Z:uQ\u001d!\u0012\u0011NA1\u0007W\n#a!\u001c\u0002Sm\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0GJ|7o\u001d*fM\u0016\u0014XM\\2fQ\r!\"\u0011\u0002\u0015\u000f)]\fy!!\u0005\u0002\u0016\rM\u0014QIB;Y\t\u00119'\t\u0002\u0004x\u0005\t4I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#vl\u0011*P'N{&+\u0012$F%\u0016s5)\u0012\u0011usB,\u0017\u0001D4fi>\u0003XM]1uS>tG\u0003BB?\u0007\u000b\u0003B!\u00170\u0004\u0000A\u0019!m!!\n\u0007\r\r5MA\u0007Pa\u0016\u0014\u0018\r^5p]\u0012\u000bG/\u0019\u0005\u0007\u0003/*\u0002\u0019\u0001$)\u0011\r\u0015\u00151LA1\u0003GBs!FA5\u0003C\u001aY)\t\u0002\u0004\u000e\u0006Q2p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og\"\u0012Q\u0003\u001c\u0015\u000f+]\fy!!\u0005\u0002\u0016\rM\u0015QIBOY\t\u0019)j\u000b\u0006\u0002\u001c\u0005\u001d\u0012\u0011FA\u0017\u0007/[c!!\r\u00028\re5FBA\u001e\u0003\u0003\u001aYj\t\u0002\u0004\u0000\u0005\u00121qT\u00016O\u0016$\b\u0005\u001e5fA1L7\u000f\u001e\u0011pM\u0002\nG\u000e\u001c\u0011usB,\u0007e\u001c9fe\u0006$\u0018n\u001c8tA\t,Gn\u001c8hAQ|\u0007e]3tg&|g\u000eK\u0004\u0001\u0007G\u000b\tg!+\u0011\u00075\u001c)+C\u0002\u0004(:\u0014\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003SAs\u0001ABW\u0003C\u001a\u0019\fE\u0002n\u0007_K1a!-o\u0005!\u0001&o\u001c3vG\u0016\u001cHFAA\u0015Q\u001d\u00011qWBb\u0007\u000b\u0004Ba!/\u0004@6\u001111\u0018\u0006\u0004\u0007{[\u0018\u0001\u0002;bONLAa!1\u0004<\n\u0019A+Y4\u0002\t9\fW.Z\u0011\u0003\u0007\u000f\fqaU3tg&|g.\u0001\tTKN\u001c\u0018n\u001c8t%\u0016\u001cx.\u001e:dKB\u00111hF\n\u0003/%\"\"aa3\u00021M+5kU%P\u001d~\u0003&k\u0014+P\u0007>cuLV#S'&{e*\u0006\u0002\u0004V>\u00111q\u001b\u0013\u0003\u00073LAaa7\u0004^\u0006a\u0002*\u0013,F?\u000ec\u0015jX*F%ZK5)R0Q%>#vjQ(M?Z\u000b$\u0002BBp\u0007C\f\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u000b\t\r\r8Q]\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\t\r\u001d8\u0011^\u0001\u0004eB\u001c'\u0002BBv\u0007[\fqa]3sm&\u001cWMC\u0002\u0004p\u0012\nA\u0001[5wK\u0006I2+R*T\u0013>su\f\u0015*P)>\u001bu\nT0W\u000bJ\u001b\u0016j\u0014(!\u0001")
public class SessionsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private Option<KyuubiBatchService> batchService;
    private volatile boolean bitmap$0;

    public static TProtocolVersion SESSION_PROTOCOL_VERSION() {
        return SessionsResource$.MODULE$.SESSION_PROTOCOL_VERSION();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        SessionsResource sessionsResource = this;
        synchronized (sessionsResource) {
            if (!this.bitmap$0) {
                this.batchService = ApiRequestContext.batchService$(this);
                this.bitmap$0 = true;
            }
        }
        return this.batchService;
    }

    @Override
    public Option<KyuubiBatchService> batchService() {
        if (!this.bitmap$0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    public org.apache.kyuubi.session.SessionHandle toSessionHandle(String str) {
        return SessionHandle$.MODULE$.fromUUID(str);
    }

    private SessionManager sessionManager() {
        return this.fe().be().sessionManager();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    public Seq<SessionData> sessions() {
        return ((TraversableOnce)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)session -> ApiUtils$.MODULE$.sessionData((KyuubiSession)((Object)session)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiSessionEvent.class))}, description="get a session event via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public KyuubiSessionEvent sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        KyuubiSessionEvent kyuubiSessionEvent;
        try {
            kyuubiSessionEvent = (KyuubiSessionEvent)((KyuubiSession)this.sessionManager().getSession(this.toSessionHandle(sessionHandleStr))).getSessionEvent().map((Function1 & Serializable & scala.Serializable)event -> KyuubiSessionEvent.builder().sessionId(event.sessionId()).clientVersion(event.clientVersion()).sessionType(event.sessionType()).sessionName(event.sessionName()).user(event.user()).clientIp(event.clientIP()).serverIp(event.serverIP()).conf((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(event.conf()).asJava()).remoteSessionId(event.remoteSessionId()).engineId(event.engineId()).eventTime(event.eventTime()).openedTime(event.openedTime()).startTime(event.startTime()).endTime(event.endTime()).totalOperations(event.totalOperations()).exception((Throwable)event.exception().orNull(Predef$.MODULE$.$conforms())).build()).get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return kyuubiSessionEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=InfoDetail.class))}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        try {
            TGetInfoType info = TGetInfoType.findByValue((int)infoType);
            TGetInfoValue infoValue = this.fe().be().getInfo(this.toSessionHandle(sessionHandleStr), info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionOpenCount.class))}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.sessionManager().getActiveUserSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExecPoolStatistic.class))}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.sessionManager().getExecPoolSize(), this.sessionManager().getActiveCount(), this.sessionManager().getWorkQueueSize());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    public SessionHandle openSession(SessionOpenRequest request) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        org.apache.kyuubi.session.SessionHandle handle = this.fe().be().openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1, userName, "", ipAddress, ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.fe().host()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.fe().connectionUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)this.fe().getRealUser())}))).toMap(Predef$.MODULE$.$conforms()));
        return new SessionHandle(handle.identifier(), this.fe().connectionUrl());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Received request of closing ").append(sessionHandleStr).toString());
        this.fe().be().closeSession(this.toSessionHandle(sessionHandleStr));
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().executeStatement(this.toSessionHandle(sessionHandleStr), request.getStatement(), ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfOverlay()).asScala()).toMap(Predef$.MODULE$.$conforms()), request.isRunAsync(), Predef$.MODULE$.Long2long(request.getQueryTimeout()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error executing statement";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTypeInfo(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting type information";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCatalogs(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting catalogs";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        try {
            OperationHandle operationHandle2;
            operationHandle = operationHandle2 = this.fe().be().getSchemas(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting schemas";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTables(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getTableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting tables";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTableTypes(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting table types";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getColumns(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getColumnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting columns";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getFunctions(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getFunctionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting functions";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_PRIMARY_KEY type")
    @POST
    @Path(value="{sessionHandle}/operations/primaryKeys")
    public OperationHandle getPrimaryKeys(@PathParam(value="sessionHandle") String sessionHandleStr, GetPrimaryKeysRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getPrimaryKeys(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting primary keys";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CROSS_REFERENCE type")
    @POST
    @Path(value="{sessionHandle}/operations/crossReference")
    public OperationHandle getCrossReference(@PathParam(value="sessionHandle") String sessionHandleStr, GetCrossReferenceRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCrossReference(this.toSessionHandle(sessionHandleStr), request.getPrimaryCatalog(), request.getPrimarySchema(), request.getPrimaryTable(), request.getForeignCatalog(), request.getForeignSchema(), request.getForeignTable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting cross reference";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OperationData.class)))}, description="get the list of all type operations belong to session")
    @GET
    @Path(value="{sessionHandle}/operations")
    public Seq<OperationData> getOperation(@PathParam(value="sessionHandle") String sessionHandleStr) {
        Seq seq;
        try {
            seq = ((TraversableOnce)this.fe().be().sessionManager().operationManager().allOperations().map((Function1 & Serializable & scala.Serializable)operation -> {
                if (StringUtils.equalsIgnoreCase((CharSequence)operation.getSession().handle().identifier().toString(), (CharSequence)sessionHandleStr)) {
                    return ApiUtils$.MODULE$.operationData((KyuubiOperation)((Object)operation));
                }
                return BoxedUnit.UNIT;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting the list of all type operations belong to session";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return seq;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

