/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http;

import java.util.List;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.CacheReturn;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.Fluent;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.GenIgnore;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.Nullable;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.VertxGen;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.MultiMap;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientRequest;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpFrame;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpVersion;
import org.apache.kyuubi.shade.io.vertx.core.http.StreamPriority;
import org.apache.kyuubi.shade.io.vertx.core.net.NetSocket;
import org.apache.kyuubi.shade.io.vertx.core.streams.ReadStream;

@VertxGen
public interface HttpClientResponse
extends ReadStream<Buffer> {
    public HttpClientResponse fetch(long var1);

    public HttpClientResponse resume();

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> var1);

    public HttpClientResponse handler(Handler<Buffer> var1);

    public HttpClientResponse pause();

    public HttpClientResponse endHandler(Handler<Void> var1);

    @CacheReturn
    public NetSocket netSocket();

    public HttpVersion version();

    public int statusCode();

    public String statusMessage();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public String getHeader(CharSequence var1);

    public @Nullable String getTrailer(String var1);

    @CacheReturn
    public MultiMap trailers();

    @CacheReturn
    public List<String> cookies();

    @Fluent
    default public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
        this.body().onSuccess(bodyHandler);
        return this;
    }

    @Fluent
    default public HttpClientResponse body(Handler<AsyncResult<Buffer>> handler) {
        Future<Buffer> fut = this.body();
        fut.onComplete(handler);
        return this;
    }

    public Future<Buffer> body();

    default public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }

    public Future<Void> end();

    @Fluent
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpClientRequest request();

    @Fluent
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> var1);
}

