/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.netty;

import java.util.ArrayList;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.grpc.EquivalentAddressGroup;
import org.apache.kyuubi.shade.io.grpc.NameResolver;
import org.apache.kyuubi.shade.io.grpc.StatusOr;
import org.apache.kyuubi.shade.io.netty.channel.unix.DomainSocketAddress;

final class UdsNameResolver
extends NameResolver {
    private NameResolver.Listener2 listener;
    private final String authority;

    UdsNameResolver(String authority, String targetPath, NameResolver.Args args) {
        Preconditions.checkArgument(authority == null, "non-null authority not supported");
        this.authority = targetPath;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState(this.listener == null, "already started");
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    @Override
    public void refresh() {
        this.resolve();
    }

    private void resolve() {
        NameResolver.ResolutionResult.Builder resolutionResultBuilder = NameResolver.ResolutionResult.newBuilder();
        ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>(1);
        servers.add(new EquivalentAddressGroup(new DomainSocketAddress(this.authority)));
        resolutionResultBuilder.setAddressesOrError(StatusOr.fromValue(servers));
        this.listener.onResult2(resolutionResultBuilder.build());
    }

    @Override
    public void shutdown() {
    }
}

