/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.zeppelin;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.zeppelin.ZeppelinServiceModelGenerator;

public class ZeppelinWSServiceModelGenerator
extends ZeppelinServiceModelGenerator {
    private static final String SERVICE = "ZEPPELINWS";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        if (this.isSSL(roleConfig)) {
            scheme = "wss";
            port = this.getSSLPort(roleConfig);
        } else {
            scheme = "ws";
            port = this.getPort(roleConfig);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/ws", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), "ssl_enabled", this.getRoleConfigValue(roleConfig, "ssl_enabled"));
        model.addRoleProperty(this.getRoleType(), "zeppelin_server_port", this.getPort(roleConfig));
        model.addRoleProperty(this.getRoleType(), "zeppelin_server_ssl_port", this.getSSLPort(roleConfig));
        return model;
    }
}

