/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.Collection;
import javax.management.openmbean.TabularData;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedRouteControllerMBean;

public interface ManagedSupervisingRouteControllerMBean
extends ManagedRouteControllerMBean {
    @ManagedAttribute(description="Whether supervising is enabled")
    public boolean isEnabled();

    @ManagedAttribute(description="The number of threads used by the scheduled thread pool that are used for restarting routes")
    public int getThreadPoolSize();

    @ManagedAttribute(description="Initial delay in milli seconds before the route controller starts")
    public long getInitialDelay();

    @ManagedAttribute(description="Backoff delay in millis when restarting a route that failed to startup")
    public long getBackOffDelay();

    @ManagedAttribute(description="Backoff maximum delay in millis when restarting a route that failed to startup")
    public long getBackOffMaxDelay();

    @ManagedAttribute(description="Backoff maximum elapsed time in millis, after which the backoff should be considered exhausted and no more attempts should be made")
    public long getBackOffMaxElapsedTime();

    @ManagedAttribute(description="Backoff maximum number of attempts to restart a route that failed to startup")
    public long getBackOffMaxAttempts();

    @ManagedAttribute(description="Backoff multiplier to use for exponential backoff")
    public double getBackOffMultiplier();

    @ManagedAttribute(description="Pattern for filtering routes to be included as supervised")
    public String getIncludeRoutes();

    @ManagedAttribute(description="Pattern for filtering routes to be excluded as supervised")
    public String getExcludeRoutes();

    @ManagedAttribute(description="Number of routes controlled by the controller")
    public int getNumberOfControlledRoutes();

    @ManagedAttribute(description="Number of routes which have failed to startup and are currently managed to be restarted")
    public int getNumberOfRestartingRoutes();

    @ManagedAttribute(description="Number of routes which have failed all attempts to startup and are now exhausted")
    public int getNumberOfExhaustedRoutes();

    @ManagedAttribute(description="Exhausted routes")
    public Collection<String> getExhaustedRoutes();

    @ManagedAttribute(description="Routes that are restarting or scheduled to restart")
    public Collection<String> getRestartingRoutes();

    @ManagedOperation(description="Lists detailed status about all the routes (incl failure details for routes failed to start)")
    public TabularData routeStatus(boolean var1, boolean var2, boolean var3);
}

