/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.xml.util.jsse.AbstractJsseUtilFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.jsse.SecureRandomParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractSecureRandomParametersFactoryBean
extends AbstractJsseUtilFactoryBean<SecureRandomParameters> {
    @XmlAttribute(required=true)
    @Metadata(description="The Random Number Generator algorithm identifier for the SecureRandom factory method used to create the SecureRandom represented by this object's configuration. See Appendix A in the Java Cryptography Architecture API Specification and Reference guide for information about standard RNG algorithm names.")
    protected String algorithm;
    @XmlAttribute
    @Metadata(description="The optional provider identifier for the SecureRandom factory method used to create the SecureRandom represented by this object's configuration.")
    protected String provider;
    @XmlTransient
    private SecureRandomParameters instance;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public SecureRandomParameters getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.instance == null) {
                this.instance = this.createInstance();
            }
            return this.instance;
        }
        return this.createInstance();
    }

    protected SecureRandomParameters createInstance() {
        SecureRandomParameters newInstance = new SecureRandomParameters();
        newInstance.setAlgorithm(this.algorithm);
        newInstance.setProvider(this.provider);
        newInstance.setCamelContext(this.getCamelContext());
        return newInstance;
    }

    @Override
    public Class<? extends SecureRandomParameters> getObjectType() {
        return SecureRandomParameters.class;
    }
}

