/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.gogo.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.commands.meta.ActionMetaData;

public class ActionMetaDataFactory {
    public ActionMetaData create(Class<? extends Action> actionClass) {
        Command command = this.getCommand(actionClass);
        HashMap<Option, Field> options = new HashMap<Option, Field>();
        HashMap<Argument, Field> arguments = new HashMap<Argument, Field>();
        ArrayList<Argument> orderedArguments = new ArrayList<Argument>();
        for (Class<? extends Action> type = actionClass; type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option == null) {
                    option = this.getAndConvertDeprecatedOption(field);
                }
                if (option != null) {
                    options.put(option, field);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) {
                    argument = this.getAndConvertDeprecatedArgument(field);
                }
                if (argument == null) continue;
                argument = this.replaceDefaultArgument(field, argument);
                arguments.put(argument, field);
                int index = argument.index();
                while (orderedArguments.size() <= index) {
                    orderedArguments.add(null);
                }
                if (orderedArguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index + " on Action " + actionClass.getName());
                }
                orderedArguments.set(index, argument);
            }
        }
        this.assertIndexesAreCorrect(actionClass, orderedArguments);
        return new ActionMetaData(actionClass, command, options, arguments, orderedArguments, null);
    }

    public Command getCommand(Class<? extends Action> actionClass) {
        Command command = actionClass.getAnnotation(Command.class);
        if (command == null) {
            command = this.getAndConvertDeprecatedCommand(actionClass);
        }
        return command;
    }

    public Command getAndConvertDeprecatedCommand(Class<? extends Action> actionClass) {
        final org.apache.felix.gogo.commands.Command oldCommand = actionClass.getAnnotation(org.apache.felix.gogo.commands.Command.class);
        if (oldCommand == null) {
            return null;
        }
        return new Command(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Command.class;
            }

            @Override
            public String scope() {
                return oldCommand.scope();
            }

            @Override
            public String name() {
                return oldCommand.name();
            }

            @Override
            public String detailedDescription() {
                return oldCommand.detailedDescription();
            }

            @Override
            public String description() {
                return oldCommand.description();
            }
        };
    }

    private Option getAndConvertDeprecatedOption(Field field) {
        final org.apache.felix.gogo.commands.Option oldOption = field.getAnnotation(org.apache.felix.gogo.commands.Option.class);
        if (oldOption == null) {
            return null;
        }
        return new Option(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Option.class;
            }

            @Override
            public String valueToShowInHelp() {
                return oldOption.valueToShowInHelp();
            }

            @Override
            public boolean required() {
                return oldOption.required();
            }

            @Override
            public String name() {
                return oldOption.name();
            }

            @Override
            public boolean multiValued() {
                return oldOption.multiValued();
            }

            @Override
            public String description() {
                return oldOption.description();
            }

            @Override
            public String[] aliases() {
                return oldOption.aliases();
            }
        };
    }

    private Argument getAndConvertDeprecatedArgument(Field field) {
        final org.apache.felix.gogo.commands.Argument oldArgument = field.getAnnotation(org.apache.felix.gogo.commands.Argument.class);
        if (oldArgument == null) {
            return null;
        }
        return new Argument(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Argument.class;
            }

            @Override
            public String valueToShowInHelp() {
                return oldArgument.valueToShowInHelp();
            }

            @Override
            public boolean required() {
                return oldArgument.required();
            }

            @Override
            public String name() {
                return oldArgument.name();
            }

            @Override
            public boolean multiValued() {
                return oldArgument.multiValued();
            }

            @Override
            public int index() {
                return oldArgument.index();
            }

            @Override
            public String description() {
                return oldArgument.description();
            }
        };
    }

    private Argument replaceDefaultArgument(Field field, Argument argument) {
        if ("##default".equals(argument.name())) {
            final Argument delegate = argument;
            final String name = field.getName();
            argument = new Argument(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String description() {
                    return delegate.description();
                }

                @Override
                public boolean required() {
                    return delegate.required();
                }

                @Override
                public int index() {
                    return delegate.index();
                }

                @Override
                public boolean multiValued() {
                    return delegate.multiValued();
                }

                @Override
                public String valueToShowInHelp() {
                    return delegate.valueToShowInHelp();
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return delegate.annotationType();
                }
            };
        }
        return argument;
    }

    private void assertIndexesAreCorrect(Class<? extends Action> actionClass, List<Argument> orderedArguments) {
        for (int i = 0; i < orderedArguments.size(); ++i) {
            if (orderedArguments.get(i) != null) continue;
            throw new IllegalArgumentException("Missing argument for index: " + i + " on Action " + actionClass.getName());
        }
    }
}

