/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.IOException;
import java.util.Arrays;
import org.apache.kafka.clients.consumer.internals.SensorBuilder;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsRegistry;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class ShareFetchMetricsManager
implements AutoCloseable {
    private final Metrics metrics;
    private final Sensor throttleTime;
    private final Sensor bytesFetched;
    private final Sensor recordsFetched;
    private final Sensor fetchLatency;
    private final Sensor sentAcknowledgements;
    private final Sensor failedAcknowledgements;

    public ShareFetchMetricsManager(Metrics metrics, ShareFetchMetricsRegistry metricsRegistry) {
        this.metrics = metrics;
        this.bytesFetched = new SensorBuilder(metrics, "bytes-fetched").withAvg(metricsRegistry.fetchSizeAvg).withMax(metricsRegistry.fetchSizeMax).withMeter(metricsRegistry.bytesFetchedRate, metricsRegistry.bytesFetchedTotal).build();
        this.recordsFetched = new SensorBuilder(metrics, "records-fetched").withAvg(metricsRegistry.recordsPerRequestAvg).withMax(metricsRegistry.recordsPerRequestMax).withMeter(metricsRegistry.recordsFetchedRate, metricsRegistry.recordsFetchedTotal).build();
        this.sentAcknowledgements = new SensorBuilder(metrics, "sent-acknowledgements").withMeter(metricsRegistry.acknowledgementSendRate, metricsRegistry.acknowledgementSendTotal).build();
        this.failedAcknowledgements = new SensorBuilder(metrics, "failed-acknowledgements").withMeter(metricsRegistry.acknowledgementErrorRate, metricsRegistry.acknowledgementErrorTotal).build();
        this.fetchLatency = new SensorBuilder(metrics, "fetch-latency").withAvg(metricsRegistry.fetchLatencyAvg).withMax(metricsRegistry.fetchLatencyMax).withMeter(new WindowedCount(), metricsRegistry.fetchRequestRate, metricsRegistry.fetchRequestTotal).build();
        this.throttleTime = new SensorBuilder(metrics, "fetch-throttle-time").withAvg(metricsRegistry.fetchThrottleTimeAvg).withMax(metricsRegistry.fetchThrottleTimeMax).build();
    }

    public Sensor throttleTimeSensor() {
        return this.throttleTime;
    }

    void recordLatency(String node, long requestLatencyMs) {
        String nodeTimeName;
        Sensor nodeRequestTime;
        this.fetchLatency.record(requestLatencyMs);
        if (!node.isEmpty() && (nodeRequestTime = this.metrics.getSensor(nodeTimeName = "node-" + node + ".latency")) != null) {
            nodeRequestTime.record(requestLatencyMs);
        }
    }

    void recordBytesFetched(int bytes) {
        this.bytesFetched.record(bytes);
    }

    void recordRecordsFetched(int records) {
        this.recordsFetched.record(records);
    }

    void recordAcknowledgementSent(int acknowledgements) {
        this.sentAcknowledgements.record(acknowledgements);
    }

    void recordFailedAcknowledgements(int acknowledgements) {
        this.failedAcknowledgements.record(acknowledgements);
    }

    @Override
    public void close() throws IOException {
        Arrays.asList(this.throttleTime.name(), this.bytesFetched.name(), this.recordsFetched.name(), this.fetchLatency.name(), this.sentAcknowledgements.name(), this.failedAcknowledgements.name()).forEach(this.metrics::removeSensor);
    }
}

