/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.fault.FaultHandler;

public class ScramPublisher
implements MetadataPublisher {
    private final int nodeId;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final CredentialProvider credentialProvider;

    public ScramPublisher(int nodeId, FaultHandler faultHandler, String nodeType, CredentialProvider credentialProvider) {
        this.nodeId = nodeId;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.credentialProvider = credentialProvider;
    }

    @Override
    public final String name() {
        return "ScramPublisher " + this.nodeType + " id=" + this.nodeId;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        try {
            ScramDelta scramDelta = delta.scramDelta();
            if (scramDelta != null) {
                scramDelta.changes().forEach((mechanism, userChanges) -> userChanges.forEach((userName, change) -> {
                    if (change.isPresent()) {
                        this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential());
                    } else {
                        this.credentialProvider.removeCredentials(mechanism, userName);
                    }
                }));
            }
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing SCRAM changes from MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset(), t);
        }
    }
}

