/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class ControllerRequestContext {
    private final KafkaPrincipal principal;
    private final OptionalLong deadlineNs;
    private final RequestHeaderData requestHeader;
    private final Consumer<Integer> partitionChangeQuotaApplier;

    public static OptionalLong requestTimeoutMsToDeadlineNs(Time time, int millisecondsOffset) {
        return OptionalLong.of(time.nanoseconds() + TimeUnit.NANOSECONDS.convert(millisecondsOffset, TimeUnit.MILLISECONDS));
    }

    public ControllerRequestContext(RequestHeaderData requestHeader, KafkaPrincipal principal, OptionalLong deadlineNs) {
        this(requestHeader, principal, deadlineNs, __ -> {});
    }

    public ControllerRequestContext(RequestHeaderData requestHeader, KafkaPrincipal principal, OptionalLong deadlineNs, Consumer<Integer> partitionChangeQuotaApplier) {
        this.requestHeader = requestHeader;
        this.principal = principal;
        this.deadlineNs = deadlineNs;
        this.partitionChangeQuotaApplier = partitionChangeQuotaApplier;
    }

    public ControllerRequestContext(AuthorizableRequestContext requestContext, OptionalLong deadlineNs) {
        this(requestContext, deadlineNs, (Integer __) -> {});
    }

    public ControllerRequestContext(AuthorizableRequestContext requestContext, OptionalLong deadlineNs, Consumer<Integer> partitionChangeQuotaApplier) {
        this(new RequestHeaderData().setRequestApiKey((short)requestContext.requestType()).setRequestApiVersion((short)requestContext.requestVersion()).setCorrelationId(requestContext.correlationId()).setClientId(requestContext.clientId()), requestContext.principal(), deadlineNs, partitionChangeQuotaApplier);
    }

    public RequestHeaderData requestHeader() {
        return this.requestHeader;
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public OptionalLong deadlineNs() {
        return this.deadlineNs;
    }

    public void applyPartitionChangeQuota(int requestedPartitionCount) {
        this.partitionChangeQuotaApplier.accept(requestedPartitionCount);
    }
}

