/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.juneau.commons.utils;

import static org.apache.juneau.commons.utils.AssertionUtils.*;

import java.util.*;

/**
 * Class-related utility methods.
 *
 */
public class ResourceBundleUtils {

	/**
	 * Same as {@link ResourceBundle#getBundle(String, Locale, ClassLoader)} but never throws a {@link MissingResourceException}.
	 *
	 * @param baseName The base name of the resource bundle, a fully qualified class name.
	 * @param locale The locale for which a resource bundle is desired.
	 * @param loader The class loader from which to load the resource bundle. Must not be <jk>null</jk>.
	 * @return The matching resource bundle, or <jk>null</jk> if it could not be found.
	 */
	public static ResourceBundle findBundle(String baseName, Locale locale, ClassLoader loader) {
		assertArgNotNull("loader", loader);
		try {
			return ResourceBundle.getBundle(baseName, locale, loader);
		} catch (@SuppressWarnings("unused") MissingResourceException e) {}
		return null;
	}
}