/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.serializer.Serializer;

public class MockRestRequest
extends RestRequest {
    private Map<String, Object> attributeMap = CollectionUtils.map();
    private Map<String, RequestDispatcher> requestDispatcherMap = CollectionUtils.map();
    private String characterEncoding;
    private String protocol;
    private String scheme;
    private String serverName;
    private String remoteAddr;
    private String remoteHost;
    private String localName;
    private String localAddr;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;
    private String remoteUser;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath;
    private String authType;
    private Integer serverPort;
    private Integer remotePort;
    private Integer localPort;
    private Locale locale;
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private Cookie[] cookies;
    private Principal userPrincipal;
    private HttpSession httpSession;
    private String[] roles;

    protected MockRestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(client, uri, method, hasBody);
    }

    public MockRestRequest accept(String value) throws RestCallException {
        super.accept(value);
        return this;
    }

    public MockRestRequest acceptCharset(String value) throws RestCallException {
        super.acceptCharset(value);
        return this;
    }

    public MockRestRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    public MockRestRequest attributes(Map<String, Object> value) {
        this.attributeMap.clear();
        this.attributeMap.putAll(value);
        return this;
    }

    public MockRestRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public MockRestRequest cancellable(Cancellable cancellable) {
        super.cancellable(cancellable);
        return this;
    }

    public MockRestRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public MockRestRequest config(RequestConfig value) {
        super.config(value);
        return this;
    }

    public MockRestRequest content(Object value) {
        super.content(value);
        return this;
    }

    public MockRestRequest content(Object input, HttpPartSchema schema) {
        super.content(input, schema);
        return this;
    }

    public MockRestRequest contentString(Object input) throws RestCallException {
        super.contentString(input);
        return this;
    }

    public MockRestRequest contentType(String value) throws RestCallException {
        super.contentType(value);
        return this;
    }

    public MockRestRequest context(HttpContext context) {
        super.context(context);
        return this;
    }

    public MockRestRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public MockRestRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public MockRestRequest debug() throws RestCallException {
        super.debug();
        return this;
    }

    public MockRestRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public MockRestRequest errorCodes(Predicate<Integer> value) {
        super.errorCodes(value);
        return this;
    }

    public MockRestRequest formData(NameValuePair ... parts) {
        super.formData(parts);
        return this;
    }

    public MockRestRequest formData(String name, Object value) {
        super.formData(name, value);
        return this;
    }

    public MockRestRequest formDataBean(Object value) {
        super.formDataBean(value);
        return this;
    }

    public MockRestRequest formDataCustom(Object value) {
        super.formDataCustom(value);
        return this;
    }

    public MockRestRequest formDataPairs(String ... pairs) throws RestCallException {
        super.formDataPairs(pairs);
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Map<String, RequestDispatcher> getRequestDispatcherMap() {
        return this.requestDispatcherMap;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public MockRestRequest header(Header part) {
        super.header(part);
        return this;
    }

    public MockRestRequest header(String name, Object value) {
        super.header(name, value);
        return this;
    }

    public MockRestRequest headerPairs(String ... pairs) {
        super.headerPairs(pairs);
        return this;
    }

    public MockRestRequest headers(Header ... parts) {
        super.headers(parts);
        return this;
    }

    public MockRestRequest headersBean(Object value) {
        super.headersBean(value);
        return this;
    }

    public MockRestRequest html() {
        super.html();
        return this;
    }

    public MockRestRequest htmlDoc() {
        super.htmlDoc();
        return this;
    }

    public MockRestRequest htmlStrippedDoc() {
        super.htmlStrippedDoc();
        return this;
    }

    public MockRestRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public MockRestRequest ignoreErrors() {
        super.ignoreErrors();
        return this;
    }

    public MockRestRequest interceptors(RestCallInterceptor ... interceptors) throws RestCallException {
        super.interceptors(interceptors);
        return this;
    }

    public MockRestRequest json() {
        super.json();
        return this;
    }

    public MockRestRequest json5() {
        super.json5();
        return this;
    }

    public MockRestRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public MockRestRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    public MockRestRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public MockRestRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public MockRestRequest mediaType(String value) throws RestCallException {
        super.mediaType(value);
        return this;
    }

    public MockRestRequest msgPack() {
        super.msgPack();
        return this;
    }

    public MockRestRequest noTrace() throws RestCallException {
        super.noTrace();
        return this;
    }

    public MockRestRequest openApi() {
        super.openApi();
        return this;
    }

    public MockRestRequest parser(Class<? extends Parser> parser) {
        super.parser(parser);
        return this;
    }

    public MockRestRequest parser(Parser parser) {
        super.parser(parser);
        return this;
    }

    public MockRestRequest pathData(NameValuePair ... parts) {
        super.pathData(parts);
        return this;
    }

    public MockRestRequest pathData(String name, Object value) {
        super.pathData(name, value);
        return this;
    }

    public MockRestRequest pathDataBean(Object value) {
        super.pathDataBean(value);
        return this;
    }

    public MockRestRequest pathDataPairs(String ... pairs) {
        super.pathDataPairs(pairs);
        return this;
    }

    public MockRestRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public MockRestRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public MockRestRequest plainText() {
        super.plainText();
        return this;
    }

    public MockRestRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public MockRestRequest protocolVersion(ProtocolVersion version) {
        super.protocolVersion(version);
        return this;
    }

    public MockRestRequest queryCustom(Object value) {
        super.queryCustom(value);
        return this;
    }

    public MockRestRequest queryData(NameValuePair ... parts) {
        super.queryData(parts);
        return this;
    }

    public MockRestRequest queryData(String name, Object value) {
        super.queryData(name, value);
        return this;
    }

    public MockRestRequest queryDataBean(Object value) {
        super.queryDataBean(value);
        return this;
    }

    public MockRestRequest queryDataPairs(String ... pairs) throws RestCallException {
        super.queryDataPairs(pairs);
        return this;
    }

    public MockRestRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public MockRestRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public MockRestRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public MockRestRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public MockRestRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public MockRestRequest requestDispatcher(String path, RequestDispatcher value) {
        this.requestDispatcherMap.put(path, value);
        return this;
    }

    public MockRestRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public MockRestRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public MockRestRequest rethrow(Class<?> ... values) {
        super.rethrow((Class[])values);
        return this;
    }

    public MockRestRequest role(String role) {
        this.roles = (String[])CollectionUtils.a((Object[])new String[]{role});
        return this;
    }

    public MockRestRequest roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    public MockRestRequest serializer(Class<? extends Serializer> serializer) {
        super.serializer(serializer);
        return this;
    }

    public MockRestRequest serializer(Serializer serializer) {
        super.serializer(serializer);
        return this;
    }

    public MockRestRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public MockRestRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public MockRestRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public MockRestRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public MockRestRequest suppressLogging() {
        super.suppressLogging();
        return this;
    }

    public MockRestRequest target(HttpHost target) {
        super.target(target);
        return this;
    }

    public MockRestRequest uon() {
        super.uon();
        return this;
    }

    public MockRestRequest uri(Object uri) throws RestCallException {
        super.uri(uri);
        return this;
    }

    public MockRestRequest uriFragment(String fragment) {
        super.uriFragment(fragment);
        return this;
    }

    public MockRestRequest uriHost(String host) {
        super.uriHost(host);
        return this;
    }

    public MockRestRequest uriPort(int port) {
        super.uriPort(port);
        return this;
    }

    public MockRestRequest uriScheme(String value) {
        super.uriScheme(value);
        this.scheme = value;
        return this;
    }

    public MockRestRequest uriUserInfo(String userInfo) {
        super.uriUserInfo(userInfo);
        return this;
    }

    public MockRestRequest uriUserInfo(String username, String password) {
        super.uriUserInfo(username, password);
        return this;
    }

    public MockRestRequest urlEnc() {
        super.urlEnc();
        return this;
    }

    public MockRestRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    public MockRestRequest xml() {
        super.xml();
        return this;
    }
}

