/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.juneau.ConfigException;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.svl.VarResolverSession;

public abstract class AnnotationApplier<A extends Annotation, B> {
    private final VarResolverSession vr;
    private final Class<A> ca;
    private final Class<B> cb;

    protected AnnotationApplier(Class<A> annotationClass, Class<B> builderClass, VarResolverSession varResolverSession) {
        this.ca = AssertionUtils.assertArgNotNull("annotationClass", annotationClass);
        this.cb = AssertionUtils.assertArgNotNull("builderClass", builderClass);
        this.vr = AssertionUtils.assertArgNotNull("vr", varResolverSession);
    }

    public abstract void apply(AnnotationInfo<A> var1, B var2);

    public Optional<Boolean> bool(String in) {
        return this.string(in).map(Boolean::parseBoolean);
    }

    public boolean canApply(Object builder) {
        return this.cb.isInstance(builder);
    }

    private Character toCharacter(String in, String loc) {
        if (in.length() != 1) {
            throw new ConfigException("Invalid syntax for character on annotation @{0}({1}): {2}", this.ca.getSimpleName(), loc, in);
        }
        return Character.valueOf(in.charAt(0));
    }

    protected Stream<String> cdl(String in) {
        return Arrays.stream(StringUtils.splita(this.vr.resolve(in))).filter(Utils::ne);
    }

    protected Optional<Character> character(String in, String loc) {
        return this.string(in).map(x -> this.toCharacter((String)x, loc));
    }

    protected Optional<Charset> charset(String in) {
        return this.string(in).map(x -> "default".equalsIgnoreCase((String)x) ? Charset.defaultCharset() : Charset.forName(x));
    }

    protected Optional<Class<?>[]> classes(Class<?>[] in) {
        return Utils.opt(in.length == 0 ? null : in);
    }

    protected Optional<Integer> integer(String in, String loc) {
        try {
            return this.string(in).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            throw new ConfigException(e, "Invalid syntax for integer on annotation @{0}({1}): {2}", this.ca.getSimpleName(), loc, in);
        }
    }

    protected Stream<String> stream(String[] in) {
        return Arrays.stream(in).map(this.vr::resolve).filter(Utils::ne);
    }

    protected Optional<String> string(String in) {
        return Utils.opt(StringUtils.isEmpty(in = this.vr.resolve(in)) ? null : in);
    }

    protected Optional<String[]> strings(String[] in) {
        return Utils.opt(in.length == 0 ? null : (String[])Arrays.stream(in).map(this.vr::resolve).filter(Utils::ne).toArray(String[]::new));
    }

    protected <T> Optional<Class<T>> type(Class<T> in) {
        return Utils.opt(in).filter(ClassUtils.NOT_VOID);
    }

    protected VarResolverSession vr() {
        return this.vr;
    }
}

