/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.commons.collections.FilteredSet;
import org.apache.juneau.commons.collections.FluentSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Sets<E> {
    private Set<E> set;
    private boolean unmodifiable;
    private boolean sparse;
    private boolean concurrent;
    private boolean ordered = false;
    private Comparator<E> comparator;
    private Predicate<E> filter;
    private Class<E> elementType;
    private Function<Object, E> elementFunction;

    public static <E> Sets<E> create(Class<E> elementType) {
        return new Sets<E>(AssertionUtils.assertArgNotNull("elementType", elementType));
    }

    public Sets(Class<E> elementType) {
        this.elementType = AssertionUtils.assertArgNotNull("elementType", elementType);
    }

    public Sets<E> add(E value) {
        if (this.set == null) {
            this.set = this.ordered ? new LinkedHashSet() : (Utils.nn(this.comparator) ? new TreeSet<E>(this.comparator) : new HashSet());
        }
        this.set.add(value);
        return this;
    }

    public Sets<E> add(E ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        for (E v : values) {
            this.add(v);
        }
        return this;
    }

    public Sets<E> addAll(Collection<E> value) {
        if (Utils.nn(value)) {
            if (this.set == null) {
                this.set = this.ordered ? new LinkedHashSet<E>(value) : (Utils.nn(this.comparator) ? new TreeSet<E>(this.comparator) : new HashSet<E>(value));
            } else {
                this.set.addAll(value);
            }
        }
        return this;
    }

    public Sets<E> addAny(Object ... values) {
        if (Utils.nn(values)) {
            for (Object o : values) {
                if (!Utils.nn(o)) continue;
                if (o instanceof Collection) {
                    Collection o2 = (Collection)o;
                    o2.forEach(x -> this.addAny(x));
                    continue;
                }
                if (Utils.isArray(o)) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        this.addAny(Array.get(o, i));
                    }
                    continue;
                }
                if (this.elementType.isInstance(o)) {
                    this.add(this.elementType.cast(o));
                    continue;
                }
                E converted = this.convertElement(o);
                if (converted != null) {
                    this.add(converted);
                    continue;
                }
                throw ThrowableUtils.rex("Object of type {0} could not be converted to type {1}", Utils.cn(o), Utils.cn(this.elementType));
            }
        }
        return this;
    }

    public Sets<E> addIf(boolean flag, E value) {
        if (flag) {
            this.add(value);
        }
        return this;
    }

    public Sets<E> addJson(String ... values) {
        return this.addAny(values);
    }

    public Set<E> build() {
        if (this.sparse && Utils.e(this.set)) {
            return null;
        }
        Set<E> set2 = null;
        set2 = this.ordered ? new LinkedHashSet() : (Utils.nn(this.comparator) ? new TreeSet<E>(this.comparator) : new HashSet());
        if (this.concurrent) {
            set2 = Collections.synchronizedSet(set2);
        }
        if (Utils.nn(this.filter) || Utils.nn(this.elementFunction)) {
            FilteredSet.Builder set3b = FilteredSet.create(this.elementType);
            if (Utils.nn(this.filter)) {
                set3b.filter(this.filter);
            }
            if (Utils.nn(this.elementFunction)) {
                set3b.elementFunction(this.elementFunction);
            }
            set2 = set3b.inner(set2).build();
        }
        if (Utils.nn(this.set)) {
            set2.addAll(this.set);
        }
        if (this.unmodifiable) {
            set2 = Collections.unmodifiableSet(set2);
        }
        return set2;
    }

    public FluentSet<E> buildFluent() {
        Set<E> result = this.build();
        return result == null ? null : new FluentSet<E>(result);
    }

    public FilteredSet<E> buildFiltered() {
        Set<E> s = this.build();
        if (s == null) {
            return null;
        }
        if (s instanceof FilteredSet) {
            FilteredSet s2 = (FilteredSet)s;
            return s2;
        }
        return FilteredSet.create(this.elementType).inner(s).build();
    }

    public Sets<E> elementFunction(Function<Object, E> elementFunction) {
        this.elementFunction = AssertionUtils.assertArgNotNull("elementFunction", elementFunction);
        return this;
    }

    public Sets<E> elementType(Class<E> value) {
        this.elementType = AssertionUtils.assertArgNotNull("value", value);
        return this;
    }

    public Sets<E> filtered() {
        return this.filtered(v -> {
            Collection v3;
            Map v2;
            Number v32;
            Boolean v22;
            return !(v == null || v instanceof Boolean && (v22 = (Boolean)v).equals(false) || v instanceof Number && (v32 = (Number)v).intValue() == -1 || Utils.isArray(v) && Array.getLength(v) == 0 || v instanceof Map && (v2 = (Map)v).isEmpty() || v instanceof Collection && (v3 = (Collection)v).isEmpty());
        });
    }

    public Sets<E> filtered(Predicate<E> filter) {
        Predicate<E> newFilter = AssertionUtils.assertArgNotNull("filter", filter);
        this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
        return this;
    }

    public Sets<E> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public Sets<E> sorted(Comparator<E> comparator) {
        this.comparator = AssertionUtils.assertArgNotNull("comparator", comparator);
        this.ordered = false;
        return this;
    }

    public Sets<E> sparse() {
        this.sparse = true;
        return this;
    }

    public Sets<E> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public Sets<E> concurrent() {
        this.concurrent = true;
        return this;
    }

    public Sets<E> concurrent(boolean value) {
        this.concurrent = value;
        return this;
    }

    public Sets<E> ordered() {
        return this.ordered(true);
    }

    public Sets<E> ordered(boolean value) {
        this.ordered = value;
        if (this.ordered) {
            this.comparator = null;
        }
        return this;
    }

    private E convertElement(Object o) {
        if (this.elementType.isInstance(o)) {
            return (E)o;
        }
        if (Utils.nn(this.elementFunction)) {
            return this.elementFunction.apply(o);
        }
        return null;
    }
}

