/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.microservice.resources.LogEntryFormatter;

public class LogParser
implements Iterable<Entry>,
Iterator<Entry>,
Closeable {
    private BufferedReader br;
    LogEntryFormatter formatter;
    Date start;
    Date end;
    Set<String> loggerFilter;
    Set<String> severityFilter;
    String threadFilter;
    private Entry next;

    static String toHtml(String s) {
        if (s.indexOf(60) != -1) {
            return s.replaceAll("<", "&lt;");
        }
        return s;
    }

    public LogParser(LogEntryFormatter formatter, File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        String line;
        this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));
        this.formatter = formatter;
        this.start = start;
        this.end = end;
        this.threadFilter = thread;
        if (Utils.nn(loggers)) {
            this.loggerFilter = new LinkedHashSet<String>(CollectionUtils.l(loggers));
        }
        if (Utils.nn(severity)) {
            this.severityFilter = new LinkedHashSet<String>(CollectionUtils.l(severity));
        }
        while (this.next == null && Utils.nn(line = this.br.readLine())) {
            Entry e = new Entry(line);
            if (!e.matches()) continue;
            this.next = e;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    @Override
    public boolean hasNext() {
        return Utils.nn(this.next);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }

    @Override
    public Entry next() {
        Entry current = this.next;
        Entry prev = this.next;
        try {
            this.next = null;
            String line = null;
            while (this.next == null && Utils.nn(line = this.br.readLine())) {
                Entry e = new Entry(line);
                if (e.isRecord) {
                    if (e.matches()) {
                        this.next = e;
                    }
                    prev = null;
                    continue;
                }
                if (!Utils.nn(prev)) continue;
                prev.addText(e.line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return current;
    }

    @Override
    public void remove() {
        throw new NoSuchMethodError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer w) throws IOException {
        try {
            if (!this.hasNext()) {
                w.append("[EMPTY]");
            } else {
                for (Entry le : this) {
                    le.append(w);
                }
            }
        }
        finally {
            this.close();
        }
    }

    public class Entry {
        public Date date;
        public String severity;
        public String logger;
        protected String line;
        protected String text;
        protected String thread;
        protected List<String> additionalText;
        protected boolean isRecord;

        Entry(String line) throws IOException {
            try {
                this.line = line;
                Matcher m = LogParser.this.formatter.getLogEntryPattern().matcher(line);
                if (m.matches()) {
                    this.isRecord = true;
                    String s = LogParser.this.formatter.getField("date", m);
                    if (Utils.nn(s)) {
                        this.date = LogParser.this.formatter.getDateFormat().parse(s);
                    }
                    this.thread = LogParser.this.formatter.getField("thread", m);
                    this.severity = LogParser.this.formatter.getField("level", m);
                    this.logger = LogParser.this.formatter.getField("logger", m);
                    this.text = LogParser.this.formatter.getField("msg", m);
                    if (Utils.nn(this.logger) && this.logger.indexOf(46) > -1) {
                        this.logger = this.logger.substring(this.logger.lastIndexOf(46) + 1);
                    }
                }
            }
            catch (ParseException e) {
                throw ThrowableUtils.ioex(e);
            }
        }

        public Writer appendHtml(Writer w) throws IOException {
            w.append(LogParser.toHtml(this.line)).append("<br>");
            if (Utils.nn(this.additionalText)) {
                for (String t : this.additionalText) {
                    w.append(LogParser.toHtml(t)).append("<br>");
                }
            }
            return w;
        }

        public String getText() {
            if (this.additionalText == null) {
                return this.text;
            }
            int i = this.text.length();
            for (String s : this.additionalText) {
                i += s.length() + 1;
            }
            StringBuilder sb = new StringBuilder(i);
            sb.append(this.text);
            for (String s : this.additionalText) {
                sb.append('\n').append(s);
            }
            return sb.toString();
        }

        public String getThread() {
            return this.thread;
        }

        protected Writer append(Writer w) throws IOException {
            w.append(this.line).append('\n');
            if (Utils.nn(this.additionalText)) {
                for (String t : this.additionalText) {
                    w.append(t).append('\n');
                }
            }
            return w;
        }

        void addText(String t) {
            if (this.additionalText == null) {
                this.additionalText = new LinkedList<String>();
            }
            this.additionalText.add(t);
        }

        boolean matches() {
            if (!this.isRecord) {
                return false;
            }
            if (Utils.nn(LogParser.this.start) && this.date.before(LogParser.this.start)) {
                return false;
            }
            if (Utils.nn(LogParser.this.end) && this.date.after(LogParser.this.end)) {
                return false;
            }
            if (Utils.nn(LogParser.this.threadFilter) && !LogParser.this.threadFilter.equals(this.thread)) {
                return false;
            }
            if (Utils.nn(LogParser.this.loggerFilter) && !LogParser.this.loggerFilter.contains(this.logger)) {
                return false;
            }
            return !Utils.nn(LogParser.this.severityFilter) || LogParser.this.severityFilter.contains(this.severity);
        }
    }
}

