/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.json.JsonSerializer;

public abstract class SwaggerElement {
    private boolean strict;
    private Map<String, Object> extra;

    SwaggerElement() {
    }

    SwaggerElement(SwaggerElement copyFrom) {
        this.strict = copyFrom.strict;
        this.extra = CollectionUtils.copyOf(copyFrom.extra);
    }

    public JsonMap asMap() {
        JsonMap m = new JsonMap();
        this.keySet().forEach(x -> m.put((String)x, this.get((String)x, (Class)Object.class)));
        return m;
    }

    @Beanp(value="*")
    public Set<String> extraKeys() {
        return this.extra == null ? Collections.emptySet() : this.extra.keySet();
    }

    @Beanp(value="*")
    public Object get(String property) {
        AssertionUtils.assertArgNotNull("property", property);
        return Utils.opt(this.extra).map(x -> x.get(property)).orElse(null);
    }

    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return ConverterUtils.toType(this.get(property), type);
    }

    public Set<String> keySet() {
        return this.extraKeys();
    }

    @Beanp(value="*")
    public SwaggerElement set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        if (this.strict) {
            throw ThrowableUtils.rex("Cannot set property ''{0}'' in strict mode.", property);
        }
        if (this.extra == null) {
            this.extra = CollectionUtils.map();
        }
        this.extra.put(property, value);
        return this;
    }

    public String toString() {
        return JsonSerializer.DEFAULT_SORTED.toString(this);
    }

    protected boolean isStrict() {
        return this.strict;
    }

    protected SwaggerElement strict() {
        this.strict = true;
        return this;
    }

    protected SwaggerElement strict(Object value) {
        AssertionUtils.assertArgNotNull("value", value);
        this.strict = ConverterUtils.toBoolean(value);
        return this;
    }
}

