/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterProcedure
extends QueryIter1 {
    private final Procedure proc;
    private boolean initialized = false;
    private QueryIterator procIter = null;

    public QueryIterProcedure(QueryIterator input, Procedure proc, ExecutionContext execCxt) {
        super(input, execCxt);
        this.proc = proc;
    }

    private void init() {
        if (!this.initialized) {
            this.procIter = this.proc.proc(this.getInput(), this.getExecContext());
            this.initialized = true;
        }
    }

    @Override
    protected void closeSubIterator() {
        this.init();
        this.procIter.close();
    }

    @Override
    protected void requestSubCancel() {
        if (this.procIter != null) {
            this.procIter.cancel();
        }
    }

    @Override
    protected boolean hasNextBinding() {
        this.init();
        return this.procIter.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        this.init();
        return this.procIter.nextBinding();
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Lib.className(this));
        out.print(" ");
        this.proc.output(out, sCxt);
    }
}

