/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpProject
extends OpModifier {
    private List<Var> vars = new ArrayList<Var>();

    public OpProject(Op subOp, List<Var> vars) {
        super(subOp);
        this.vars = vars;
    }

    public List<Var> getVars() {
        return this.vars;
    }

    @Override
    public String getName() {
        return "project";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpProject(subOp, this.vars);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        return this.vars.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpProject)) {
            return false;
        }
        OpProject opProject = (OpProject)other;
        if (!Objects.equals(this.vars, opProject.vars)) {
            return false;
        }
        return this.getSubOp().equalTo(opProject.getSubOp(), labelMap);
    }
}

